@echo off
setlocal

rem Usage: compile.bat [image] [file]
rem Defaults: image=sacredbanana/amiga-compiler:m68k-amigaos, file=.devcontainer\add3.c

set IMAGE=%1
if "%IMAGE%"=="" set IMAGE=sacredbanana/amiga-compiler:m68k-amigaos

set FILE=%2
if "%FILE%"=="" set FILE=.devcontainer\add3.c

for %%f in ("%FILE%") do set OUT=%%~nf

set WORKSPACE=%CD%

echo Using image: %IMAGE%
echo Compiling %FILE% -> %OUT%

docker run --rm -v "%WORKSPACE%:/opt/project" -w /opt/project %IMAGE% /bin/sh -lc "gcc -g '%FILE%' -o '%OUT%'"
if %ERRORLEVEL% neq 0 (
  echo Compile failed with exit code %ERRORLEVEL%
  endlocal
  exit /b %ERRORLEVEL%
)

echo Done. Output: %WORKSPACE%\%OUT%
endlocal
