(*---------------------------------------------------------------------------
    :Program.     PopMenu.mod
    :Contents.    Routinen, um ein simples Auswahlmen beim Mauszeiger
    :Contents.    erscheinen zu lassen.
    :Author.      Bernd Preusing (aus C bersetzt, angepat und verfeinert)
    :Address.     Gerhardstr. 16  D-2200 Elmshorn
    :Phone.       04121/22486
    :Copyright.   Public Domain
    :Language.    Modula-2
    :Translator.  M2Amiga V3.2e
    :Support.     Helene (Lee) Taran (C-Programm Splines, Fish Disk #57)
    :History.     V1.0 Preusing 26-Apr-89
    :History.     10.Mar.90 neucompiliert m2V3.3d Dimbeck
    :Bugs.        Nicht fr GimmeZeroZero-Windows!
    :Remark.      Great, Helene!
    :Remark.      Das Original macht LockLayers auf irgendwas, nur nicht auf
    :Remark.      die betroffenen Layer, dies ist korrigiert.
---------------------------------------------------------------------------*)
IMPLEMENTATION MODULE PopMenu;

FROM SYSTEM     IMPORT  ADR, ADDRESS, CAST, BITSET;
FROM Arts       IMPORT  CurrentLevel, TermProcedure, Assert;
FROM Exec       IMPORT  Byte, GetMsg, ReplyMsg, WaitPort;
FROM Graphics   IMPORT  RastPort, RastPortPtr, ClipRect, ClipRectPtr, BitMap,
                        BitMapPtr, TextAttr, TextFontPtr, FontStyleSet,
                        FontFlagSet, jam1, DrawModes, DrawModeSet,
                        RastPortFlags,
                        AllocRaster, CloseFont, FreeRaster, OpenFont,
                        SetFont, InitRastPort, InitBitMap, SetDrMd,
                        SetAPen, RectFill, Move, Text;
FROM Intuition  IMPORT  WindowPtr, Window, IDCMPFlags, IDCMPFlagSet, selectUp,
                        IntuiMessage, IntuiMessagePtr, ModifyIDCMP,
                        WindowFlags, WindowFlagSet;
FROM Layers     IMPORT  LockLayers, UnlockLayers, SwapBitsRastPortClipRect;


VAR
    MenuFont: TextFontPtr;
    MenuAttr: TextAttr;
    StartLevel: INTEGER;


PROCEDURE InsideWindow(x,y:INTEGER; window:WindowPtr):BOOLEAN;
BEGIN
  WITH window^ DO
    RETURN (x>=0) AND (x<width) AND (y>=0) AND (y<height)
  END;
END InsideWindow;


PROCEDURE StructPopUp(VAR Menu:PopUpMenu; Depth:INTEGER; oCol,aCol:Byte);
BEGIN
  WITH Menu DO
    depth:=Depth;
    left:=0; top:=0;
    width:=0; height:=0;
    deactivate:=selectUp;
    outlineColor:=oCol;
    areaColor:=aCol;
    firstItem:=NIL;
    activeItem:=NIL
  END;
END StructPopUp;

PROCEDURE AddItem(VAR Menu:PopUpMenu; VAR Item:PopUpItem; Mtext:ADDRESS;
                        Id:INTEGER; Color:Byte);
VAR ActItem, LastItem:PopUpItemPtr;
BEGIN
  ActItem:=Menu.firstItem;
  IF ActItem=NIL THEN
    Menu.firstItem:=ADR(Item)
  ELSE
    WHILE ActItem#NIL DO
      LastItem:=ActItem;
      ActItem:=ActItem^.next
    END;
    LastItem^.next:=ADR(Item);
  END;
  WITH Item DO
    text:=Mtext;
    selectionId:=Id;
    left:=3; top:=1;
    height:=0;
    width:=0;
    color:=Color;
    next:=NIL;
  END
END AddItem;


PROCEDURE InitPopUp(VAR Menu:PopUpMenu);
VAR Item: PopUpItemPtr;
    Longest, TotalHeight, i:INTEGER;
    MenuRast: RastPortPtr;

  PROCEDURE Max(a,b:INTEGER):INTEGER;
  BEGIN
    IF a>b THEN RETURN a
    ELSE RETURN b END
  END Max;

  PROCEDURE Length(adr:ADDRESS):INTEGER;
  VAR len:INTEGER;
  BEGIN
    len:=0;
    WHILE CAST(Byte,adr^)#0 DO
      INC(len);
      INC(adr);
    END;
    RETURN len
  END Length;

BEGIN
  Longest:=0;
  TotalHeight:=2;
  MenuRast:=CAST(RastPortPtr,ADR(Menu.rp));
  Item:=Menu.firstItem;
  WHILE Item#NIL DO
    WITH Item^ DO
      width:=Max(width,FONTWIDTH*Length(text)+5);
      left:=Max(3,left);
      Longest:=Max(Longest,width+left);
      height:=Max(height,FONTHEIGHT);
      top:=Max(0,top);
      INC(TotalHeight,height+top);
      top:=TotalHeight-height;
      Item:=next;
    END;
  END;
  WITH Menu DO
    height:=TotalHeight+2;
    width:=Max(width,Longest);
    InitBitMap(bitmap,depth,width,height);
    InitRastPort(rp);
    SetFont(MenuRast,MenuFont);
    FOR i:=0 TO depth-1 DO
      bitmap.planes[i]:=AllocRaster(width,height);
      Assert(bitmap.planes[i]#NIL,ADR('no memory for menu raster'));
    END;
    rp.bitMap:=ADR(bitmap);
    cr.bitMap:=ADR(bitmap);
    SetDrMd(ADR(rp),jam1);
    SetAPen(MenuRast,areaColor);
    MenuRast^.aOlPen:=outlineColor;
    INCL(MenuRast^.flags,areaOutline);
    RectFill(MenuRast,0,0,width-1,height-1);
    RectFill(MenuRast,1,1,width-2,height-2);
    EXCL(MenuRast^.flags,areaOutline);

    Item:=firstItem;
  END;
  WHILE Item#NIL DO
    WITH Item^ DO
      SetAPen(ADR(Menu.rp),color);
      Move(ADR(Menu.rp),left,top+FONTBASELINE);
      Text(ADR(Menu.rp),text,Length(text));
      Item:=next
    END;
  END;
END InitPopUp;


PROCEDURE ComplementItem(VAR Menu:PopUpMenu; Item:PopUpItemPtr;
                         window:WindowPtr);
VAR OldMode:DrawModeSet;
BEGIN
  IF Item=NIL THEN RETURN END;
  WITH window^.wScreen^ DO
    OldMode:=rastPort.drawMode;
    SetDrMd(ADR(rastPort),DrawModeSet{complement});
    RectFill(ADR(rastPort),Menu.left+2,
                   Menu.top+Item^.top-1,
                   Menu.left+Menu.width-3,
                   Menu.top+Item^.top+Item^.height-1);
    SetDrMd(ADR(rastPort),OldMode);
  END;
END ComplementItem;


PROCEDURE SelectItem(VAR Menu:PopUpMenu; window:WindowPtr);
VAR Item:PopUpItemPtr;
    x,y:INTEGER;
    NotFound:BOOLEAN;
BEGIN
  WITH window^ DO
    x:=mouseX+leftEdge;
    y:=mouseY+topEdge;
  END;
  WITH Menu DO
    Item:=firstItem;
    DEC(x,left); DEC(y,top);
    IF (x>=0) AND (x<width) AND (y>=0) AND (y<height) THEN
      NotFound:=TRUE;
      WHILE (Item#NIL) AND NotFound DO
        WITH Item^ DO
          IF (y>=top-1) AND (y<top+height) THEN
            NotFound:=FALSE
          ELSE
            Item:=next
          END
        END
      END;
    ELSE
      Item:=NIL
    END;
    IF activeItem#Item THEN
      ComplementItem(Menu,activeItem,window);
      ComplementItem(Menu,Item,window);
    END;
    activeItem:=Item;
  END;
END SelectItem;

PROCEDURE PopUp(VAR Menu:PopUpMenu; window:WindowPtr):INTEGER;
VAR
  OldFlags: IDCMPFlagSet;
  Left, Top: INTEGER;
  message: IntuiMessagePtr;
  msg: IntuiMessage;
  MouseMoved:BOOLEAN;
  OldWindowFlags:WindowFlagSet;
BEGIN
  WITH window^ DO
    Left:=mouseX;
    Top:=mouseY;
    IF NOT InsideWindow(Left,Top,window) THEN
      RETURN OUTSIDEWINDOW
    END;
    INC(Left,leftEdge);
    Left:=CAST(INTEGER,CAST(BITSET,Left)-BITSET{0..3});
    INC(Top,topEdge);
    WITH wScreen^ DO
      LockLayers(ADR(layerInfo));
      IF ((Left+Menu.width)>width) THEN
        Left:=Left-Menu.width;
      END;
      IF ((Top+Menu.height)>height) THEN
        Top:=Top-Menu.height;
      END;
    END;
    IF Top<0 THEN Top:=0 END;
    IF Left<0 THEN Left:=0 END;
    Left:=CAST(INTEGER,CAST(BITSET,Left)-BITSET{0..3});
    WITH Menu.cr.bounds DO
      minX:=Left;
      minY:=Top;
      maxX:=Left+Menu.width-1;
      maxY:=Top+Menu.height-1;
    END;
    SwapBitsRastPortClipRect(ADR(wScreen^.rastPort),ADR(Menu.cr));
    Menu.left:=Left;
    Menu.top:=Top;
    SelectItem(Menu,window);
    OldFlags:=idcmpFlags;
    ModifyIDCMP(window,OldFlags+IDCMPFlagSet{mouseMove,mouseButtons}); (* ??? *)
    OldWindowFlags:=flags;
    INCL(flags,reportMouse);
    LOOP
      MouseMoved:=FALSE;
      WaitPort(userPort);
      REPEAT
        message:=GetMsg(userPort);
        IF message#NIL THEN
          msg:=message^;
          ReplyMsg(message);
          IF msg.class=IDCMPFlagSet{mouseMove} THEN
            MouseMoved:=TRUE
          ELSIF (msg.class=IDCMPFlagSet{mouseButtons}) AND
                (msg.code=Menu.deactivate) THEN
            ModifyIDCMP(window,OldFlags);
            flags:=OldWindowFlags;
            SelectItem(Menu,window);
            SwapBitsRastPortClipRect(ADR(wScreen^.rastPort),ADR(Menu.cr));
            UnlockLayers(ADR(wScreen^.layerInfo));
            IF Menu.activeItem#NIL THEN
              RETURN Menu.activeItem^.selectionId
            ELSE
              RETURN NOITEMSELECTED
            END;
          END;
        END;
      UNTIL message=NIL;
      IF MouseMoved THEN
        SelectItem(Menu,window)
      END;
    END;
  END;
END PopUp;

PROCEDURE DisposePopUp(VAR Menu:PopUpMenu);
VAR i:INTEGER;
BEGIN
  WITH Menu DO
    FOR i:=0 TO depth-1 DO
      IF bitmap.planes[i]#NIL THEN
        FreeRaster(bitmap.planes[i],width,height);
        bitmap.planes[i]:=NIL
      END
    END
  END
END DisposePopUp;


PROCEDURE Cleanup;
BEGIN
  IF CurrentLevel()<=StartLevel THEN
    IF MenuFont#NIL THEN
      CloseFont(MenuFont);
      MenuFont:=NIL;
    END;
  END
END Cleanup;

BEGIN (* main *)
  StartLevel:=CurrentLevel();
  MenuFont:=NIL;
  WITH MenuAttr DO
    name:=ADR('topaz.font');
    ySize:=8;
    style:=FontStyleSet{};
    flags:=FontFlagSet{}
  END;
  MenuFont:=OpenFont(ADR(MenuAttr));
  Assert(MenuFont#NIL,ADR("can't open topaz.8"));
  TermProcedure(Cleanup);
END PopMenu.mod
