(*
-------------------------------------------------------------------
   :Program.       Logikus.mod
   :Contents.      Simuliert den Spielcomputer LOGIKUS von KOSMOS
   :Author.        Franz X. Dimbeck
   :ADdress.       Troppauerstr. 48, D-8058 Erding, BRD
   :Phone.         08122 18135
   :Copyright.     Public Domain
   :Language.      Modula-2
   :Translator.    M2Amiga V3.3d
   :History.       V1.1 13.Mar.1990
   :Support.       IffToCode fr Maus und Img
   :Imports.       IconSupport [fbs]         Amok#5
   :Imports.       PopMenu     Bernd Preusig AMOK#21
   :Remark.        Fr Nostalgiker, Oldtimer etc.
   :Usage.         Logikus [file]
-------------------------------------------------------------------
*)

(* $R- $V- $S- $F- $L- *)
MODULE Logikus;

FROM Arguments   IMPORT GetArg ,NumArgs ;
FROM ARP         IMPORT FileRequest , FileRequester  , FileName , DirName ,
                        FileReqFlagSet ;
FROM Arts        IMPORT CurrentLevel , TermProcedure ,
                        Requester  ;
FROM Dos         IMPORT Delay  ;
FROM Exec        IMPORT GetMsg , ReplyMsg  ;
FROM FileSystem  IMPORT Response ,   File , Lookup ,
                        Close , ReadByteBlock , WriteByteBlock ;
FROM Graphics    IMPORT DrawModeSet , SetDrMd , jam2 , DrawModes , Move ,
                        Draw , WaitTOF , Text , SetAPen , SetBPen ,
                        SetRGB4 ,  ReadPixel , ViewPortPtr ;
FROM IconSupport IMPORT CreateIcon ;
FROM Img         IMPORT ImgPtr ,Imgwidth ,Imgheight ,Imgdepth ;
FROM Intuition   IMPORT
                        AddGadget ,CloseWindow ,  IDCMPFlags ,
                        IDCMPFlagSet , Image , ImagePtr ,
                        IntuiMessagePtr , menuDown , menuUp ,
                        ModifyIDCMP ,
                         RefreshGadgets , ScreenToFront  ,
                        selectUp , selectDown , SetPointer ,
                        SetWindowTitles , ShowTitle , strGadget
                         ,WindowFlags ,WindowFlagSet ;
FROM LogiGraph   IMPORT Bild  , Schieber , Schalter , Farben1 , Farben2 ,
                        Farben3 , MyWindow , MyScreen , MyRast , MyGadget ,
                        Streifen , Lampen , Buf , UBuf , String80 ,
                        IniGadg , Taster , Tastan , AboutWindow ;
FROM Maus        IMPORT pfeil ,hand ,stift ,schere ,Mausheight ,MausPtr ;
FROM PopMenu     IMPORT PopUpItem , PopUpMenu , StructPopUp , AddItem ,
                        InitPopUp , PopUp , DisposePopUp ,
                        NOITEMSELECTED , OUTSIDEWINDOW ;
FROM Str         IMPORT Length , Concat , Compare ;
FROM SYSTEM      IMPORT ADR   ;
FROM Workbench   IMPORT WBObjectType ;

CONST
   maxspalte = 19;
   maxzeile  = 10;
   (* Zeile 10 fr Quelle(sp0), Lampen(sp1..10), Ta(sp11),Tb(sp12) *)
   maxdraht  = 200;

TYPE
   Coord    = RECORD
                 x : INTEGER;
                 y : INTEGER;
              END;
   FeldPtr  = POINTER TO Feld3;
   Draht    = RECORD
                 AnfZ      : [0..10];
                 AnfS      : [0..maxspalte];
                 AnfP      : [1..3];  (*Lochnummer pm z[]  *)
                 EndZ      : [0..10];
                 EndS      : [0..maxspalte];
                 EndP      : [1..3];  (*Lochnummer pm z[]  *)
                 StPunkte  : ARRAY [0..10] OF Coord;
                 Nr        : [0..maxdraht];
              END;
   Feld3    = RECORD
                 z         : ARRAY[0..3] OF FeldPtr;
                 d         : ARRAY[1..3] OF POINTER TO Draht;
                 nextcheck : [0..4];
                 von       : FeldPtr;
                 strom     : BOOLEAN;
              END;

VAR
   Ciapra [0BFE001H]: SET OF (s0,s1,s2,s3,s4,s5,lmb);
   fehler ,pressed     : BOOLEAN;
   loesch ,rot ,titel   : BOOLEAN;
   x , y , z , s , zm ,
   sm , pm , i , j      : INTEGER;
   Plan               : ARRAY [0..maxspalte] OF
                           ARRAY [0..maxzeile] OF Feld3;
   (* Plan [0..maxspalte,0..9] ist Kontaktfeld
      Plan [1..10,10]          ist Lampenfeld
      Plan [0,10]              ist Quelle
      Plan [11,10]             ist Ta
      Plan [12,10]             ist Tb
   *)
   Drahtzahl        : [0..maxdraht];
   Draehte          : ARRAY [0..maxdraht] OF Draht;
   MyView           : ViewPortPtr ;
   Dummy            : LONGINT;
   MyMenu           : PopUpMenu;
   MyItem1, MyItem2,
   MyItem3, MyItem4,
   MyItem5, MyItem6,
   MyItem7, MyItem8 : PopUpItem;
   StartLevel       : INTEGER;
   Quit , ok ,
   veraendert ,li ,
   schrift ,Knopf    : BOOLEAN;
   Infile , Outfile  : File;
   Infilename ,
   Outfilename ,
   Ueberschrift ,
   Ergebnis ,
   Progname ,
   Titel , DefTitel ,
   Leerstring       : String80;
   Dateiname        : FileName;
   Verzeichnisname  : DirName;
   l ,Antwort        : LONGINT;
   MeinReqStruct    : FileRequester;
   MeinIcon         : Image;

PROCEDURE InitReq;
BEGIN
   Dateiname := "";
   WITH MeinReqStruct DO
      hail      := ADR(Ueberschrift);
      ddef      := ADR(Dateiname);
      ddir      := ADR(Verzeichnisname);
      wind      := MyWindow;
      funcFlags := FileReqFlagSet{};
      reserved1 := 0;
      function  := NIL;
      reserved2 := 0;
   END;
   Antwort  := 0;
   Ergebnis := "";
END InitReq;

PROCEDURE FRequester(Laden:BOOLEAN);
BEGIN
   veraendert := TRUE;
   IF Laden THEN
      Ueberschrift := " L A D E N ";
   ELSE
      Ueberschrift := " S P E I C H E R N ";
   END;
   Farben3;
   Antwort := FileRequest(ADR(MeinReqStruct));
   Farben1;
   IF (Antwort=0) THEN RETURN END;
   IF (Length(Dateiname)=0) THEN Antwort := 0; RETURN END;
   Ergebnis := "";
   Concat(Ergebnis,Verzeichnisname);
   l := Length(Ergebnis);
   IF (l>0) AND (Ergebnis[l-1] # ":") THEN Concat(Ergebnis,"/"); END;
   Concat(Ergebnis,Dateiname);
   IF Laden THEN
      Infilename  := Ergebnis;
   ELSE
      Outfilename := Ergebnis;
   END;
END FRequester;


PROCEDURE Cleanup;
BEGIN
   IF CurrentLevel()<=StartLevel THEN
      DisposePopUp(MyMenu);
   END;
END Cleanup;

PROCEDURE InitMenu;
BEGIN
   StructPopUp(MyMenu,4,13,2);
   MyMenu.deactivate := menuUp;
   INCL(MyWindow^.flags,rmbTrap);
   AddItem (MyMenu, MyItem1,ADR(" Neu "),1,0);
   AddItem (MyMenu, MyItem2,ADR(" Laden "),2,0);
   AddItem (MyMenu, MyItem3,ADR(" Speichern "),3,0);
   AddItem (MyMenu, MyItem4,ADR(" analytisch an/aus "),4,0);
   MyItem4.top := 5;
   AddItem (MyMenu, MyItem5,ADR(" About "),5,0);
   AddItem (MyMenu, MyItem6,ADR(" Titelleiste an/aus  "),6,0);
   AddItem (MyMenu, MyItem7,ADR(" Bildschirm neu zeichnen "),7,0);
   MyItem7.top := 5;
   AddItem (MyMenu, MyItem8,ADR("------- E N D E----------"),8,13);
   MyItem8.top := 5;
   InitPopUp(MyMenu);
END InitMenu;

PROCEDURE Striche;
VAR
   Breite, Hoehe,
   x1,x2,y1,y2,i,j  : INTEGER;
   f1, f2           : CARDINAL;
BEGIN
   f1 := 14; f2 := 14;
   IF rot THEN  f2 := 0 END;
   Breite := 29;
   Hoehe  := 24;
   SetDrMd (MyRast,jam2);
   FOR i := 0 TO 9 DO
      x1 := 73+i*2*Breite;
      x2 := x1+Breite;
      FOR j := 0 TO 4 DO
         y1 := 75+j*(Hoehe+2);
         y2 := y1+Hoehe;
         IF Schalter[i] THEN
            SetAPen(MyRast,f2)
         ELSE
            SetAPen(MyRast,f1)
         END;
         Move(MyRast,x1+7,y1+6);
         Draw(MyRast,x2-7,y1+6);
         IF Schalter[i] THEN
            SetAPen(MyRast,f1)
         ELSE
            SetAPen(MyRast,f2)
         END;
         Move(MyRast,x1+7,y2-6);
         Draw(MyRast,x2-7,y2-6);
      END;
   END;
END Striche;


PROCEDURE DrahtNeu ;
VAR  i, j :INTEGER;
BEGIN
   SetDrMd (MyRast,jam2);
   SetAPen (MyRast,15);
   FOR i := 1 TO Drahtzahl DO
      j := 1;
      WITH Draehte[i] DO
         WHILE (StPunkte[j].x # 0) DO
            Move(MyRast,StPunkte[j-1].x,StPunkte[j-1].y);
            Draw(MyRast,StPunkte[j].x,StPunkte[j].y);
            Move(MyRast,StPunkte[j-1].x+1,StPunkte[j-1].y);
            Draw(MyRast,StPunkte[j].x+1,StPunkte[j].y);
            INC(j);
         END;
      END;
   END;
END DrahtNeu;



PROCEDURE InitPlan0;
VAR i, j, k : INTEGER;
BEGIN
   veraendert := TRUE;
   WITH Plan[0,10] DO
      FOR k := 1 TO 3  DO
         z[k] := NIL;
         d[k] := NIL;
         nextcheck  := 1;
         von        := NIL;
         strom      := TRUE;
      END;
   END;
   FOR i := 0 TO maxdraht DO
      FOR j := 0 TO 10 DO
         Draehte[i].StPunkte[j].x := 0;
      END;
   END;
   Drahtzahl := 0;
   FOR i := 0 TO 9 DO
      Schalter[i] := FALSE;
      WITH Plan[i+1,10] DO
         FOR k := 1 TO 3 DO
            z[k] := NIL;
            d[k] := NIL;
         END;
         nextcheck  := 1;
         von        := NIL;
         strom      := FALSE;
      END;
   END;
   FOR i :=0 TO maxspalte DO
      FOR j := 0 TO maxzeile-1 DO
         WITH Plan[i,j] DO
            FOR k := 1 TO 3 DO
               z[k] := NIL;
               d[k] := NIL;
            END;
            nextcheck := 0;
            von     := NIL;
            strom   := FALSE;
            IF ODD(j) THEN
               IF ODD(i) THEN
                 z[0] := ADR(Plan[i-1,j]);
               ELSE
                 z[0] := ADR(Plan[i+1,j]);
               END;
            ELSE
               z[0] := NIL;
            END;
         END;
      END; (*FOR j*)
   END; (*FOR i*)
   FOR i := 11 TO 12 DO
      WITH Plan[i,10] DO
         FOR k := 1 TO 3 DO
            z[k] := NIL;
            d[k] := NIL;
         END;
         nextcheck := 0;
         von     := NIL;
         strom   := FALSE;
         z[0] := NIL;
      END;
   END;
   Leerstring := " ";
   Buf[0] := Leerstring; UBuf[0] := Buf[0];
   Buf[1] := Leerstring; UBuf[1] := Buf[1];
   UBuf[2] :=
   "    0     1       2      3      4      5       6      7      8      9";
   Buf[2] := UBuf[2];
   Buf[3] := Leerstring; UBuf[3] := Buf[3];
   Buf[4] := Leerstring; UBuf[4] := Buf[4];
   FOR i := 0 TO 4 DO
      RefreshGadgets(MyGadget[i], MyWindow, NIL);
   END;
   Lampen;
   Streifen;
END InitPlan0 ;

PROCEDURE Mausknopf():BOOLEAN;
VAR
   InMsg  : IntuiMessagePtr;
   Code   : CARDINAL;
   Action : INTEGER;
   Class  : IDCMPFlagSet;
BEGIN
   InMsg := GetMsg(MyWindow^.userPort);
   IF InMsg = NIL THEN RETURN Knopf END;
   Code  := InMsg^.code;
   Class := InMsg^.class;
   ReplyMsg(InMsg);
   IF (Class = IDCMPFlagSet{mouseButtons}) THEN
      IF (Code = selectDown) THEN Knopf := TRUE; END;
      IF (Code = selectUp)   THEN Knopf := FALSE; END;
   END;
   RETURN Knopf;
END Mausknopf;

PROCEDURE Maus(VAR x,y:INTEGER);
BEGIN
   x := MyWindow^.mouseX;
   y := MyWindow^.mouseY;
END Maus;

PROCEDURE Laden1;
VAR i  : INTEGER;
p1, p2 : FeldPtr;
Id,Id0 : ARRAY [0..12] OF CHAR;
BEGIN
   Id0 :=  "Logikus-Daten" ;
   Lookup (Infile,Infilename,1024,FALSE);
   IF (Infile.res = done) THEN
      ReadByteBlock(Infile,Id);
      IF (Compare(Id,Id0) # 0) THEN
         ok := Requester(ADR(Infilename),
                 ADR("ist keine Logikus-Datei!")
                ,NIL,ADR(" schade!")) ;
         Close(Infile);
         RETURN
      END;
      InitPlan0;
      ReadByteBlock(Infile,Drahtzahl);
      FOR  i := 1 TO Drahtzahl DO
         ReadByteBlock(Infile,Draehte[i]);
      END;
      Titel := DefTitel;
      Concat(Titel,Infilename);
      SetWindowTitles(MyWindow,NIL,ADR(Titel));
      FOR i := 0 TO 4 DO
         ReadByteBlock(Infile,Buf[i]);
         UBuf[i] := Buf[i];
         RefreshGadgets(MyGadget[i], MyWindow, NIL);
      END;
      Farben2;
      Bild;
      Striche;
      DrahtNeu;
      Farben1;
      FOR i := 1 TO Drahtzahl DO
         WITH Draehte[i] DO
            p1 := ADR(Plan[AnfS,AnfZ]);
            p2 := ADR(Plan[EndS,EndZ]);
            p1^.z[AnfP] := p2;
            p1^.d[AnfP] := ADR(Draehte[i]);
            p2^.z[EndP] := p1;
            p2^.d[EndP] := ADR(Draehte[i]);
         END;
      END;
   ELSE
      ok := Requester(ADR(Infilename),
                       ADR("kann nicht geladen werden!")
                      ,NIL,ADR(" schade!"))            ;
      Infilename := "";
      Dateiname  := "";
   END; (* IF (Infile.res = done) *)
   Close(Infile);
END Laden1;

PROCEDURE Laden;
BEGIN
   FRequester(TRUE);
   IF (Antwort=0) THEN RETURN END;
   Laden1;
END Laden;

PROCEDURE Speichern;
VAR
   i  : INTEGER ;
   ok : BOOLEAN;
   Id : ARRAY [0..12] OF CHAR;
BEGIN
   Id := "Logikus-Daten";
   FRequester(FALSE);
   IF (Antwort=0) THEN RETURN END;
   Lookup (Outfile,Outfilename,1024,TRUE);
   IF Outfile.res # done THEN
      ok := Requester(ADR(Outfilename),
                       ADR("kann nicht gespeichert werden!")
                      ,NIL,ADR(" schade!"));
      Dateiname := "";
      RETURN
   END;
   WriteByteBlock(Outfile,Id);
   WriteByteBlock(Outfile,Drahtzahl);
   FOR  i := 1 TO Drahtzahl DO
      WriteByteBlock(Outfile,Draehte[i]);
   END;
   FOR i := 0 TO 4 DO
      WriteByteBlock(Outfile,Buf[i]);
   END;
   Close(Outfile);
   ok := CreateIcon(ADR(Outfilename),
                    ADR(MeinIcon),
                    NIL,
                    FALSE,
                    project,
                    ADR(Progname));
   Titel := DefTitel;
   Concat(Titel,Outfilename);
   SetWindowTitles(MyWindow,NIL,ADR(Titel));
END Speichern;

PROCEDURE FarbDraehte();
VAR
   i : [0..maxdraht];
   j : [0..10];
   st: BOOLEAN;
BEGIN
   SetDrMd (MyRast,jam2);
   SetAPen (MyRast,13);
   FOR i := 1 TO Drahtzahl DO
      WITH Draehte[i] DO
         SetAPen(MyRast,15);
         IF  (Plan[AnfS,AnfZ].strom OR Plan[EndS,EndZ].strom) THEN
            SetAPen(MyRast,13);
         END;
         j := 1;
         WHILE (StPunkte[j].x # 0) DO
            Move(MyRast,StPunkte[j-1].x,StPunkte[j-1].y);
            Draw(MyRast,StPunkte[j].x,StPunkte[j].y);
            Move(MyRast,StPunkte[j-1].x+1,StPunkte[j-1].y);
            Draw(MyRast,StPunkte[j].x+1,StPunkte[j].y);
            INC(j);
         END;
      END;
   END;
END FarbDraehte;



PROCEDURE RotDraht;
VAR
   n : [0..maxdraht];
   j : [0..10];
BEGIN
   n := Plan[s,z].d[pm]^.Nr;
   SetDrMd (MyRast,DrawModeSet{complement});
   SetAPen (MyRast,13);
   j := 1;
   WITH Draehte[n] DO
      WHILE (StPunkte[j].x # 0) DO
         Move(MyRast,StPunkte[j-1].x,StPunkte[j-1].y);
         Draw(MyRast,StPunkte[j].x,StPunkte[j].y);
         INC(j);
      END;
      Delay(5);
      j := 1;
      WHILE (StPunkte[j].x # 0) DO
         Move(MyRast,StPunkte[j-1].x,StPunkte[j-1].y);
         Draw(MyRast,StPunkte[j].x,StPunkte[j].y);
         INC(j);
      END;
   END;
   Delay(5);
END RotDraht;

PROCEDURE coxy(VAR x,y,z,s,pm :INTEGER);
BEGIN
   schrift := FALSE;
   z := (y-75)/13;
   s := (x-73)/29;
   zm := (y-75) MOD 13;
   IF ODD(z) THEN zm := zm+1 END;
   pm := 1 + (zm)/4;
   IF zm MOD 4  = 0 THEN pm := 0 END;
   sm := (x-73) MOD 58;
   IF sm>13 THEN s := s+1  END;
   IF (sm<1) OR (((sm>7) AND (sm<22)) OR (sm>28)) THEN
      pm := 0;
      sm := 0;
      s := -1;
   END;
   IF (x<73) OR (y<76) THEN s := -1; pm := 0; END;
   IF ((y<48) AND (y>11) AND (x>47)) THEN schrift := TRUE END;
   IF (y>211) AND (y<219) THEN schrift := TRUE END;
   IF y>203 THEN s := -1; pm := 0; END;
   IF z>9 THEN z := -1 END;
   IF ((y>48) AND (y<52)) THEN     (* Quelle und Lampen *)
      z := 10;
      s := (x-8)/59;
      sm := (x-8) MOD 59;
      pm :=1+ sm/6;
      IF sm MOD 6 = 0 THEN
         pm := 0;
      END;
   END;
   IF x<36 THEN
      z := 10;
      sm := (x-8) MOD 59;
      pm := 1+sm/6;
      IF sm MOD 6 = 0 THEN
         pm := 0;
      END;
      IF ((y>73) AND (y<77)) THEN         (* Ta *)
         s := 11;
      ELSIF ((y>98) AND (y<102)) THEN     (* Tb *)
         s := 12;
      ELSIF (y>48) AND (y<52) THEN
         s := 0;
      ELSE
         pm := 0;
      END;
   END;
   IF (pm=0) OR ((pm>3) OR (z>10)) THEN z := -1; pm := 0; END;
   loesch := FALSE;
   IF pm#0 THEN
         IF (Plan[s,z].z[pm]#NIL) THEN loesch := TRUE; END;
   END;
   IF ((pm=0) OR (loesch AND li))  THEN
      IF schrift THEN
         SetRGB4(MyView,17,15,11,6);
         SetRGB4(MyView,18,0,0,0);
         SetRGB4(MyView,19,15,0,0);
         SetPointer(MyWindow,MausPtr[stift],Mausheight,16,0,0);
      ELSE
         SetRGB4(MyView,17,15,0,0);
         SetRGB4(MyView,18,0,0,0);
         SetRGB4(MyView,19,15,10,5);
         SetPointer(MyWindow,MausPtr[hand],Mausheight,16,0,0);
         SetDrMd (MyRast,DrawModeSet{complement});
      END;
   ELSE
      x := s*29+73+4;
      IF ODD(s) THEN x := x-8 END;
      y := z*13+75-2+4*pm;
      IF ODD(z) THEN y := y-1 END;
      IF z=10 THEN
         x := s*59+7+6*pm;

         y := 50;
         IF s=11 THEN x := 7+6*pm; y := 75  END;
         IF s=12 THEN x := 7+6*pm; y := 100 END;
      END;
      IF (loesch AND (NOT li)) THEN
         SetRGB4(MyView,17,15,0,0);
         SetRGB4(MyView,18,0,0,0);
         SetRGB4(MyView,19,14,14,11);
         SetPointer(MyWindow,MausPtr[schere],Mausheight,16,0,0);
         RotDraht;
      ELSE
         SetRGB4(MyView,17,15,15,5);
         SetRGB4(MyView,19,15,0,0);
         SetPointer (MyWindow,MausPtr[pfeil],Mausheight,16,0,0);
      END; (* IF *)
   END;
END coxy;

PROCEDURE Drahtweg;
VAR
   n      : [0..maxdraht];
   i,j    : INTEGER;
   aP, eP : FeldPtr;
   aN, eN : [1..3];
BEGIN
   loesch := FALSE;
   n := Plan[s,z].d[pm]^.Nr;
   WITH Draehte[n] DO
      Plan[AnfS,AnfZ].d[AnfP] := NIL;
      Plan[AnfS,AnfZ].z[AnfP] := NIL;
      Plan[EndS,EndZ].d[EndP] := NIL;
      Plan[EndS,EndZ].z[EndP] := NIL;
   END;
   veraendert := TRUE;
   SetDrMd (MyRast,jam2);
   SetAPen (MyRast,1);
   j := 1;
   WITH Draehte[n] DO
      WHILE (StPunkte[j].x # 0) DO
         Move(MyRast,StPunkte[j-1].x,StPunkte[j-1].y);
         Draw(MyRast,StPunkte[j].x,StPunkte[j].y);
         Move(MyRast,StPunkte[j-1].x+1,StPunkte[j-1].y);
         Draw(MyRast,StPunkte[j].x+1,StPunkte[j].y);
         StPunkte[j-1].x := 0;
         INC(j);
      END;
      StPunkte[j-1].x := 0;
   END;
   FOR i := n TO Drahtzahl-1 DO
      Draehte[i]:= Draehte[i+1];
      s  := Draehte[i].AnfS;
      z  := Draehte[i].AnfZ;
      aP := ADR(Plan[s,z]);
      s  := Draehte[i].EndS;
      z  := Draehte[i].EndZ;
      eP := ADR(Plan[s,z]);
      aN := Draehte[i].AnfP;
      eN := Draehte[i].EndP;
      aP^.d[aN] := ADR(Draehte[i]);
      eP^.d[eN] := ADR(Draehte[i]);
      Draehte[i].Nr := i;
   END;
   Drahtzahl := Drahtzahl-1;
END Drahtweg;

PROCEDURE VonQuelle;
VAR
   p0,p1,p2 : FeldPtr;
   i,j     : INTEGER;
BEGIN
   p1 := ADR(Plan[0,10]);
   p0 := p1;
   LOOP
      i := p1^.nextcheck;
      IF (i < 4) THEN
         p2 := p1^.z[i];
         INC(p1^.nextcheck);
         IF ((p2 # NIL)AND(p2^.strom = FALSE)AND(p1^.von # p2))THEN
            p2^.strom := TRUE;
            p2^.von := p1;
            p1 := p2;
         END;
      ELSE
         p1 := p1^.von;
      END;
      IF (p1=ADR(Plan[0,10])) AND (p1^.nextcheck > 3) THEN EXIT
      END;
   END;
END VonQuelle;


PROCEDURE Anzeige;
VAR i,j : INTEGER;
BEGIN
   j := 0;
   FOR i := 1 TO 10 DO
      IF Plan[i,10].strom=TRUE THEN INC(j) END;
   END;
   IF j=10 THEN DEC(j) END;
   IF rot THEN j := 1 END;
   FOR i := 1 TO 10 DO
      IF Plan[i,10].strom=TRUE THEN
         SetRGB4(MyView,i+2,16-j,12-j,9-j);
      ELSE
         SetRGB4(MyView,i+2,5,2,0);
      END;
   END;
END Anzeige;

PROCEDURE Stromlauf;
BEGIN
   VonQuelle;
   Anzeige;
   IF rot THEN
      FarbDraehte;
   END;
END Stromlauf;

PROCEDURE InitPlan1;
VAR i,j,k :INTEGER;
BEGIN
   WITH Plan[0,10] DO
      nextcheck  := 1;
      von        := NIL;
      strom      := TRUE;
   END;
   FOR i := 0 TO 9 DO
      WITH Plan[i+1,10] DO
         nextcheck  := 1;
         von        := NIL;
         strom      := FALSE;
      END;
   END;
   FOR i :=0 TO maxspalte DO
      FOR j := 0 TO maxzeile DO
         WITH Plan[i,j] DO
            nextcheck := 0;
            von     := NIL;
            strom   := FALSE;
         END;
      END;
   END;
END InitPlan1;

PROCEDURE InitIcon;
BEGIN
   WITH MeinIcon DO
      leftEdge   := 0;
      topEdge    := 0;
      width      := Imgwidth;
      height     := Imgheight;
      depth      := Imgdepth;
      imageData  := ImgPtr;
      planePick  := 3;
      planeOnOff := 0;
      nextImage  := NIL;
   END;
END InitIcon;

PROCEDURE Druckschalter ;
BEGIN
   pressed := TRUE;
   Tastan;
   Plan[11,10].z[0] := ADR(Plan[12,10]);
   Plan[12,10].z[0] := ADR(Plan[11,10]);
   InitPlan1 ;
   Stromlauf;
END Druckschalter;

PROCEDURE Lin;
VAR
xalt,yalt,xneu,
yneu,pm,dx,dy   : INTEGER;
Punkte          : [1..10];
Loch1,Loch2     : [1..3];
p1, p2          : FeldPtr;
Breite,Hoehe,
x1,x2,y1,y2,jj  : INTEGER;
BEGIN
   Breite := 29;
   Hoehe  := 24;
   li     := FALSE;
   Maus(x,y);
   coxy(x,y,z,s,pm);
   IF (y>203) THEN
      s := (x-79)/58;
      IF (ReadPixel(MyRast,x,y)=13)  THEN
         veraendert := TRUE;
         IF (x<79) THEN
            Druckschalter
         ELSE
            Schalter [s] := NOT Schalter[s];
            Schieber(s,Schalter[s]);
            IF rot THEN
               x1 := 73+s*2*Breite;
               x2 := x1+Breite;
               FOR jj := 0 TO 4 DO
                  y1 := 75+jj*(Hoehe+2);
                  y2 := y1+Hoehe;
                  IF Schalter[s] THEN
                     SetAPen(MyRast,0)
                  ELSE
                     SetAPen(MyRast,14)
                  END;
                  Move(MyRast,x1+7,y1+6);
                  Draw(MyRast,x2-7,y1+6);
                  IF Schalter[s] THEN
                     SetAPen(MyRast,14)
                  ELSE
                     SetAPen(MyRast,0)
                  END;
                  Move(MyRast,x1+7,y2-6);
                  Draw(MyRast,x2-7,y2-6);
               END;
            END;
            i := s*2;
            FOR j := 0 TO maxzeile-1 DO
               IF Plan[i,j].z[0]    # NIL THEN
                  Plan[i,j].z[0]   := NIL;
                  Plan[i+1,j].z[0] := NIL;
               ELSE
                  Plan[i,j].z[0]   := ADR(Plan[i+1,j]);
                  Plan[i+1,j].z[0] := ADR(Plan[i,j]);
               END;
            END; (* FOR j *)
         END; (* IF *)
      END; (* IF *)
      WHILE Mausknopf() DO Delay(3); END;
      IF pressed THEN
         Taster;
         Plan[11,10].z[0] := NIL;
         Plan[12,10].z[0] := NIL;
         pressed := FALSE;
      END;
      SetAPen(MyRast,15);
   ELSE
      WHILE Mausknopf() DO
         Maus(xalt,yalt);
         coxy(xalt,yalt,z,s,pm);
      END;
      IF loesch THEN Drahtweg; RETURN END;
      IF (pm=0)  THEN RETURN END;
      (* Drhte*)
      veraendert := TRUE;
      li := TRUE;
      Drahtzahl := Drahtzahl+1;
      Punkte := 1;
      p1 :=  ADR(Plan[s,z]);
      WITH Draehte[Drahtzahl] DO
         AnfS          := s;
         AnfZ          := z;
         AnfP          := pm;
         Loch1         := pm;
         StPunkte[0].x := xalt;
         StPunkte[0].y := yalt;
         Nr            := Drahtzahl;
      END;
      Plan[s,z].d[pm]  := ADR(Draehte[Drahtzahl]);
      LOOP
         SetDrMd (MyRast,DrawModeSet{complement});
         WHILE NOT Mausknopf() DO
            Maus(xneu,yneu);
            coxy(xneu,yneu,z,s,pm);
            IF yneu>208 THEN yneu := 208 END;
            IF yneu<49  THEN yneu := 49  END;
            FOR i := 1 TO 2 DO
               Move(MyRast,xalt,yalt);
               Draw(MyRast,xneu,yneu);
               dx := ABS(xalt-xneu);
               dy := ABS(yalt-yneu);
               IF dy>dx THEN
                  Move(MyRast,xalt+1,yalt);
                  Draw(MyRast,xneu+1,yneu);
               END;
               Delay(3);
               WaitTOF;
            END;
         END;
         SetDrMd (MyRast,jam2);
         SetAPen (MyRast,15);
         Move(MyRast,xalt,yalt);
         Draw(MyRast,xneu,yneu);
         Move(MyRast,xalt+1,yalt);
         Draw(MyRast,xneu+1,yneu);
         Draehte[Drahtzahl].StPunkte[Punkte].x := xneu;
         Draehte[Drahtzahl].StPunkte[Punkte].y := yneu;
         IF (Punkte < 10) THEN
            Draehte[Drahtzahl].StPunkte[Punkte+1].x := 0;
         END;
         IF (Punkte < 9) THEN
            Punkte := Punkte+1;
            xalt   := xneu;
            yalt   := yneu;
 (*      ELSE
            SetAPen (MyRast,1);
            Move(MyRast,xalt,yalt);
            Draw(MyRast,xneu,yneu);
            Move(MyRast,xalt+1,yalt);
            Draw(MyRast,xneu+1,yneu);
 *)
         END;
         IF loesch THEN
            pm := 0;
         END;
         IF pm #0 THEN
            p2 :=  ADR(Plan[s,z]);
            WITH Draehte[Drahtzahl] DO
               EndS  := s;
               EndZ  := z;
               EndP  := pm;
               Loch2 := pm;
            END;
            p1^.z[Loch1]    := p2;
            p2^.z[Loch2]    := p1;
            Plan[s,z].d[pm] := ADR(Draehte[Drahtzahl]);
            EXIT
         END;
         WHILE Mausknopf() DO
            Delay(3);
         END;
      END; (*LOOP*)
      WHILE Mausknopf() DO
         Delay(3);
      END;
      li := FALSE;
   END (*IF*);
END Lin;

PROCEDURE DoIDCMP;
VAR
   InMsg  : IntuiMessagePtr;
   Code   : CARDINAL;
   Action : INTEGER;
   Class  : IDCMPFlagSet;
   z      : [0..maxzeile];
   s      : [0..maxspalte];
   n      : [0..maxdraht];
   i      : INTEGER;
BEGIN
   InMsg := GetMsg(MyWindow^.userPort);
   IF InMsg = NIL THEN RETURN END;
   Code  := InMsg^.code;
   Class := InMsg^.class;
   ReplyMsg(InMsg);
   IF (Class = IDCMPFlagSet{gadgetUp}) THEN Streifen; Lampen; END;
   IF (Class = IDCMPFlagSet{mouseButtons}) AND (Code = selectDown) THEN
      Knopf := TRUE;
      Lin;
   END;
   IF (Class = IDCMPFlagSet{mouseButtons}) AND (Code = menuDown) THEN
      Action := PopUp(MyMenu,MyWindow);
      CASE Action OF
         | NOITEMSELECTED : ;
         | OUTSIDEWINDOW  : ;
         | 1 : Farben2; InitPlan0 ; Bild;Striche; Farben1;
         | 2 : Laden;
         | 3 : Speichern;
         | 4 : rot := NOT rot;
               veraendert := TRUE;
               Striche;
               IF rot THEN
                  FarbDraehte;
               ELSE
                  DrahtNeu;
               END;
         | 5 : AboutWindow;
         | 6 : titel := NOT titel; ShowTitle(MyScreen,titel);
         | 7 : Farben2; Bild; Striche; DrahtNeu;
               veraendert := TRUE; Farben1;
         | 8 : Quit := TRUE;
      END;
   END;
END DoIDCMP;

BEGIN (*Hauptprogramm*)
   Titel    := "Logikus V1.1 :";
   SetWindowTitles(MyWindow,NIL,ADR(Titel));
   DefTitel := Titel;
   StartLevel := CurrentLevel();
   TermProcedure(Cleanup);
   InitPlan0;
   GetArg(0,Progname,i);
   IF (NumArgs() > 0) THEN
      GetArg(1,Infilename,i);
      Laden1;
   END;
   Bild;
   DrahtNeu;
   Farben1 ;
   InitReq;
   ModifyIDCMP(MyWindow,
               IDCMPFlagSet{mouseButtons,mouseMove,gadgetUp});
   InitMenu;
   InitIcon;
   MyView := ADR(MyScreen^.viewPort);
   ScreenToFront(MyScreen);
   x      := 1;
   Quit   := FALSE;
   WHILE NOT Quit DO
      Maus(x,y);
      coxy(x,y,z,s,pm);
      li := FALSE;
      DoIDCMP;
      IF veraendert THEN
         InitPlan1;
         Stromlauf;
         veraendert := FALSE ;
      END;
    END;
END Logikus.mod
(*-----------------------------------------------------------------*)
