/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.master.balancer.TableLoadBalancer;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.1.0")
public class HostRegexTableLoadBalancer
extends TableLoadBalancer {
    private static final SecureRandom random = new SecureRandom();
    private static final String PROP_PREFIX = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey();
    private static final Logger LOG = LoggerFactory.getLogger(HostRegexTableLoadBalancer.class);
    public static final String HOST_BALANCER_PREFIX = PROP_PREFIX + "balancer.host.regex.";
    public static final String HOST_BALANCER_OOB_CHECK_KEY = PROP_PREFIX + "balancer.host.regex.oob.period";
    private static final String HOST_BALANCER_OOB_DEFAULT = "5m";
    public static final String HOST_BALANCER_REGEX_USING_IPS_KEY = PROP_PREFIX + "balancer.host.regex.is.ip";
    public static final String HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.concurrent.migrations";
    private static final int HOST_BALANCER_REGEX_MAX_MIGRATIONS_DEFAULT = 250;
    protected static final String DEFAULT_POOL = "HostTableLoadBalancer.ALL";
    private static final int DEFAULT_OUTSTANDING_MIGRATIONS = 0;
    public static final String HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.max.outstanding.migrations";
    private static final Set<KeyExtent> EMPTY_MIGRATIONS = Collections.emptySet();
    private volatile long lastOOBCheck = System.currentTimeMillis();
    private Map<String, SortedMap<TServerInstance, TabletServerStatus>> pools = new HashMap<String, SortedMap<TServerInstance, TabletServerStatus>>();
    private final Map<KeyExtent, TabletMigration> migrationsFromLastPass = new HashMap<KeyExtent, TabletMigration>();
    private final Map<String, Long> tableToTimeSinceNoMigrations = new HashMap<String, Long>();
    private AccumuloConfiguration.Deriver<HrtlbConf> hrtlbConf;
    private LoadingCache<TableId, AccumuloConfiguration.Deriver<Map<String, String>>> tablesRegExCache;

    private static Map<String, String> getRegexes(AccumuloConfiguration aconf) {
        HashMap<String, String> regexes = new HashMap<String, String>();
        Map customProps = aconf.getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
        if (customProps != null && !customProps.isEmpty()) {
            for (Map.Entry customProp : customProps.entrySet()) {
                if (!((String)customProp.getKey()).startsWith(HOST_BALANCER_PREFIX) || ((String)customProp.getKey()).equals(HOST_BALANCER_OOB_CHECK_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_REGEX_USING_IPS_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY)) continue;
                String tableName = ((String)customProp.getKey()).substring(HOST_BALANCER_PREFIX.length());
                String regex = (String)customProp.getValue();
                regexes.put(tableName, regex);
            }
        }
        return Map.copyOf(regexes);
    }

    protected synchronized Map<String, SortedMap<TServerInstance, TabletServerStatus>> splitCurrentByRegex(SortedMap<TServerInstance, TabletServerStatus> current) {
        LOG.debug("Performing pool recheck - regrouping tablet servers based on regular expressions");
        HashMap<String, SortedMap<TServerInstance, TabletServerStatus>> newPools = new HashMap<String, SortedMap<TServerInstance, TabletServerStatus>>();
        for (Map.Entry<TServerInstance, TabletServerStatus> entry : current.entrySet()) {
            List<String> poolNames = this.getPoolNamesForHost(entry.getKey().getHost());
            for (String pool : poolNames) {
                TreeMap<TServerInstance, TabletServerStatus> np = (TreeMap<TServerInstance, TabletServerStatus>)newPools.get(pool);
                if (np == null) {
                    np = new TreeMap<TServerInstance, TabletServerStatus>(current.comparator());
                    newPools.put(pool, np);
                }
                np.put(entry.getKey(), entry.getValue());
            }
        }
        if (newPools.get(DEFAULT_POOL) == null) {
            LOG.warn("Default pool is empty; assigning all tablet servers to the default pool");
            TreeMap<TServerInstance, TabletServerStatus> dp = new TreeMap<TServerInstance, TabletServerStatus>(current.comparator());
            dp.putAll(current);
            newPools.put(DEFAULT_POOL, dp);
        }
        this.pools = newPools;
        LOG.trace("Pool to TabletServer mapping:");
        if (LOG.isTraceEnabled()) {
            for (Map.Entry<Object, Object> entry : this.pools.entrySet()) {
                LOG.trace("\tpool: {} -> tservers: {}", entry.getKey(), ((SortedMap)entry.getValue()).keySet());
            }
        }
        return this.pools;
    }

    protected List<String> getPoolNamesForHost(String host) {
        String test = host;
        if (!((HrtlbConf)this.hrtlbConf.derive()).isIpBasedRegex) {
            try {
                test = this.getNameFromIp(host);
            }
            catch (UnknownHostException e1) {
                LOG.error("Unable to determine host name for IP: " + host + ", setting to default pool", (Throwable)e1);
                return Collections.singletonList(DEFAULT_POOL);
            }
        }
        ArrayList<String> pools = new ArrayList<String>();
        for (Map.Entry<String, Pattern> e : ((HrtlbConf)this.hrtlbConf.derive()).poolNameToRegexPattern.entrySet()) {
            if (!e.getValue().matcher(test).matches()) continue;
            pools.add(e.getKey());
        }
        if (pools.isEmpty()) {
            pools.add(DEFAULT_POOL);
        }
        return pools;
    }

    protected String getNameFromIp(String hostIp) throws UnknownHostException {
        return InetAddress.getByName(hostIp).getHostName();
    }

    private void checkTableConfig(TableId tableId) {
        Map tableRegexes = (Map)((AccumuloConfiguration.Deriver)this.tablesRegExCache.getUnchecked((Object)tableId)).derive();
        if (!((HrtlbConf)this.hrtlbConf.derive()).regexes.equals(tableRegexes)) {
            LoggerFactory.getLogger(HostRegexTableLoadBalancer.class).warn("Table id {} has different config than system.  The per table config is ignored.", (Object)tableId);
        }
    }

    private Map<TableId, String> createdTableNameMap(Map<String, String> tableIdMap) {
        HashMap<TableId, String> tableNameMap = new HashMap<TableId, String>();
        tableIdMap.forEach((tableName, tableId) -> tableNameMap.put(TableId.of((String)tableId), (String)tableName));
        return tableNameMap;
    }

    protected String getPoolNameForTable(String tableName) {
        if (tableName == null) {
            return DEFAULT_POOL;
        }
        return ((HrtlbConf)this.hrtlbConf.derive()).poolNameToRegexPattern.containsKey(tableName) ? tableName : DEFAULT_POOL;
    }

    public String toString() {
        HrtlbConf myConf = (HrtlbConf)this.hrtlbConf.derive();
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        buf.append("\nTablet Out Of Bounds Check Interval", myConf.oobCheckMillis);
        buf.append("\nMax Tablet Server Migrations", myConf.maxTServerMigrations);
        buf.append("\nRegular Expressions use IPs", myConf.isIpBasedRegex);
        buf.append("\nPools", myConf.poolNameToRegexPattern);
        return buf.toString();
    }

    public Map<String, Pattern> getPoolNameToRegexPattern() {
        return ((HrtlbConf)this.hrtlbConf.derive()).poolNameToRegexPattern;
    }

    public int getMaxMigrations() {
        return ((HrtlbConf)this.hrtlbConf.derive()).maxTServerMigrations;
    }

    public int getMaxOutstandingMigrations() {
        return ((HrtlbConf)this.hrtlbConf.derive()).maxOutstandingMigrations;
    }

    public long getOobCheckMillis() {
        return ((HrtlbConf)this.hrtlbConf.derive()).oobCheckMillis;
    }

    public boolean isIpBasedRegex() {
        return ((HrtlbConf)this.hrtlbConf.derive()).isIpBasedRegex;
    }

    @Override
    public void init(final ServerContext context) {
        super.init(context);
        this.hrtlbConf = context.getConfiguration().newDeriver(HrtlbConf::new);
        this.tablesRegExCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<TableId, AccumuloConfiguration.Deriver<Map<String, String>>>(){

            public AccumuloConfiguration.Deriver<Map<String, String>> load(TableId key) throws Exception {
                return context.getTableConfiguration(key).newDeriver(x$0 -> HostRegexTableLoadBalancer.getRegexes(x$0));
            }
        });
        LOG.info("{}", (Object)this);
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        Map<String, SortedMap<TServerInstance, TabletServerStatus>> pools = this.splitCurrentByRegex(current);
        HashMap groupedUnassigned = new HashMap();
        unassigned.forEach((ke, lastTserver) -> groupedUnassigned.computeIfAbsent(ke.tableId(), k -> new HashMap()).put(ke, lastTserver));
        Map<TableId, String> tableIdToTableName = this.createdTableNameMap(this.getTableOperations().tableIdMap());
        for (Map.Entry e : groupedUnassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> newAssignments = new HashMap<KeyExtent, TServerInstance>();
            String tableName = tableIdToTableName.get(e.getKey());
            String poolName = this.getPoolNameForTable(tableName);
            SortedMap<TServerInstance, TabletServerStatus> currentView = pools.get(poolName);
            if (currentView == null || currentView.isEmpty()) {
                LOG.warn("No tablet servers online for table {}, assigning within default pool", (Object)tableName);
                currentView = pools.get(DEFAULT_POOL);
                if (currentView == null) {
                    LOG.error("No tablet servers exist in the default pool, unable to assign tablets for table {}", (Object)tableName);
                    continue;
                }
            }
            LOG.debug("Sending {} tablets to balancer for table {} for assignment within tservers {}", new Object[]{((Map)e.getValue()).size(), tableName, currentView.keySet()});
            this.getBalancerForTable((TableId)e.getKey()).getAssignments(currentView, (Map)e.getValue(), newAssignments);
            assignments.putAll(newAssignments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        long minBalanceTime = 20000L;
        TableOperations t = this.getTableOperations();
        if (t == null) {
            return minBalanceTime;
        }
        Map tableIdMap = t.tableIdMap();
        Map<TableId, String> tableIdToTableName = this.createdTableNameMap(tableIdMap);
        tableIdToTableName.keySet().forEach(this::checkTableConfig);
        long now = System.currentTimeMillis();
        HrtlbConf myConf = (HrtlbConf)this.hrtlbConf.derive();
        Map<String, SortedMap<TServerInstance, TabletServerStatus>> currentGrouped = this.splitCurrentByRegex(current);
        if (now - this.lastOOBCheck > myConf.oobCheckMillis) {
            try {
                for (String table : tableIdMap.keySet()) {
                    LOG.debug("Checking for out of bounds tablets for table {}", (Object)table);
                    String tablePoolName = this.getPoolNameForTable(table);
                    block6: for (Map.Entry<TServerInstance, TabletServerStatus> e : current.entrySet()) {
                        List<String> hostPools = this.getPoolNamesForHost(e.getKey().getHost());
                        if (hostPools.contains(tablePoolName)) continue;
                        String tid = (String)tableIdMap.get(table);
                        if (tid == null) {
                            LOG.warn("Unable to check for out of bounds tablets for table {}, it may have been deleted or renamed.", (Object)table);
                            continue;
                        }
                        try {
                            List<TabletStats> outOfBoundsTablets = this.getOnlineTabletsForTable(e.getKey(), TableId.of((String)tid));
                            if (outOfBoundsTablets == null) continue;
                            for (TabletStats ts : outOfBoundsTablets) {
                                KeyExtent ke = KeyExtent.fromThrift((TKeyExtent)ts.getExtent());
                                if (migrations.contains(ke)) {
                                    LOG.debug("Migration for out of bounds tablet {} has already been requested", (Object)ke);
                                    continue;
                                }
                                String poolName = this.getPoolNameForTable(table);
                                SortedMap<TServerInstance, TabletServerStatus> currentView = currentGrouped.get(poolName);
                                if (currentView != null) {
                                    int skip = random.nextInt(currentView.size());
                                    Iterator<TServerInstance> iter = currentView.keySet().iterator();
                                    for (int i = 0; i < skip; ++i) {
                                        iter.next();
                                    }
                                    TServerInstance nextTS = iter.next();
                                    LOG.info("Tablet {} is currently outside the bounds of the regex, migrating from {} to {}", new Object[]{ke, e.getKey(), nextTS});
                                    migrationsOut.add(new TabletMigration(ke, e.getKey(), nextTS));
                                    if (migrationsOut.size() < myConf.maxTServerMigrations) continue;
                                    continue block6;
                                }
                                LOG.warn("No tablet servers online for pool {}, unable to migrate out of bounds tablets", (Object)poolName);
                            }
                        }
                        catch (TException e1) {
                            LOG.error("Error in OOB check getting tablets for table {} from server {} {}", new Object[]{tid, e.getKey().getHost(), e});
                        }
                    }
                }
            }
            finally {
                this.lastOOBCheck = System.currentTimeMillis();
            }
        }
        if (!migrationsOut.isEmpty()) {
            LOG.warn("Not balancing tables due to moving {} out of bounds tablets", (Object)migrationsOut.size());
            LOG.info("Migrating out of bounds tablets: {}", migrationsOut);
            return minBalanceTime;
        }
        if (migrations != null && !migrations.isEmpty()) {
            if (migrations.size() >= myConf.maxOutstandingMigrations) {
                LOG.warn("Not balancing tables due to {} outstanding migrations", (Object)migrations.size());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)HostRegexTableLoadBalancer.limitTen(migrations));
                }
                return minBalanceTime;
            }
            LOG.debug("Current outstanding migrations of {} being applied", (Object)migrations.size());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)HostRegexTableLoadBalancer.limitTen(migrations));
            }
            this.migrationsFromLastPass.keySet().retainAll(migrations);
            TreeMap<TServerInstance, TabletServerStatus> currentCopy = new TreeMap<TServerInstance, TabletServerStatus>(current);
            HashMultimap serverTableIdCopied = HashMultimap.create();
            for (TabletMigration migration : this.migrationsFromLastPass.values()) {
                TableInfo toInfo;
                TableInfo fromInfo = this.getTableInfo(currentCopy, (Multimap<TServerInstance, String>)serverTableIdCopied, migration.tablet.tableId().toString(), migration.oldServer);
                if (fromInfo != null) {
                    fromInfo.setOnlineTablets(fromInfo.getOnlineTablets() - 1);
                }
                if ((toInfo = this.getTableInfo(currentCopy, (Multimap<TServerInstance, String>)serverTableIdCopied, migration.tablet.tableId().toString(), migration.newServer)) == null) continue;
                toInfo.setOnlineTablets(toInfo.getOnlineTablets() + 1);
            }
            migrations = EMPTY_MIGRATIONS;
        } else {
            this.migrationsFromLastPass.clear();
        }
        for (String s : tableIdMap.values()) {
            TableId tableId = TableId.of((String)s);
            String tableName = tableIdToTableName.get(tableId);
            String regexTableName = this.getPoolNameForTable(tableName);
            SortedMap<TServerInstance, TabletServerStatus> currentView = currentGrouped.get(regexTableName);
            if (currentView == null) {
                LOG.warn("Skipping balance for table {} as no tablet servers are online.", (Object)tableName);
                continue;
            }
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            this.getBalancerForTable(tableId).balance(currentView, migrations, newMigrations);
            if (newMigrations.isEmpty()) {
                this.tableToTimeSinceNoMigrations.remove(s);
            } else if (this.tableToTimeSinceNoMigrations.containsKey(s)) {
                if (now - this.tableToTimeSinceNoMigrations.get(s) > TimeUnit.HOURS.toMillis(1L)) {
                    LOG.warn("We have been consistently producing migrations for {}: {}", (Object)tableName, (Object)HostRegexTableLoadBalancer.limitTen(newMigrations));
                }
            } else {
                this.tableToTimeSinceNoMigrations.put(s, now);
            }
            migrationsOut.addAll(newMigrations);
            if (migrationsOut.size() < myConf.maxTServerMigrations) continue;
            break;
        }
        for (TabletMigration migration : migrationsOut) {
            this.migrationsFromLastPass.put(migration.tablet, migration);
        }
        LOG.info("Migrating tablets for balance: {}", migrationsOut);
        return minBalanceTime;
    }

    private TableInfo getTableInfo(SortedMap<TServerInstance, TabletServerStatus> currentCopy, Multimap<TServerInstance, String> serverTableIdCopied, String tableId, TServerInstance server) {
        HashMap<String, TableInfo> newTableMap;
        TableInfo newInfo = null;
        if (currentCopy.containsKey(server) && (newTableMap = ((TabletServerStatus)currentCopy.get(server)).getTableMap()) != null && (newInfo = (TableInfo)newTableMap.get(tableId)) != null) {
            Collection tableIdCopied = serverTableIdCopied.get((Object)server);
            if (tableIdCopied.isEmpty()) {
                newTableMap = new HashMap<String, TableInfo>(newTableMap);
                ((TabletServerStatus)currentCopy.get(server)).setTableMap(newTableMap);
            }
            if (!tableIdCopied.contains(tableId)) {
                newInfo = new TableInfo(newInfo);
                newTableMap.put(tableId, newInfo);
                tableIdCopied.add(tableId);
            }
        }
        return newInfo;
    }

    private static String limitTen(Collection<?> iterable) {
        return iterable.stream().limit(10L).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    static class HrtlbConf {
        protected long oobCheckMillis = ConfigurationTypeHelper.getTimeInMillis((String)"5m");
        private int maxTServerMigrations = 250;
        private int maxOutstandingMigrations = 0;
        private boolean isIpBasedRegex = false;
        private Map<String, String> regexes;
        private Map<String, Pattern> poolNameToRegexPattern = null;

        HrtlbConf(AccumuloConfiguration aconf) {
            String outstanding;
            String migrations;
            String ipBased;
            System.out.println("building hrtlb conf");
            String oobProperty = aconf.get(HOST_BALANCER_OOB_CHECK_KEY);
            if (oobProperty != null) {
                this.oobCheckMillis = ConfigurationTypeHelper.getTimeInMillis((String)oobProperty);
            }
            if ((ipBased = aconf.get(HOST_BALANCER_REGEX_USING_IPS_KEY)) != null) {
                this.isIpBasedRegex = Boolean.parseBoolean(ipBased);
            }
            if ((migrations = aconf.get(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY)) != null) {
                this.maxTServerMigrations = Integer.parseInt(migrations);
            }
            if ((outstanding = aconf.get(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY)) != null) {
                this.maxOutstandingMigrations = Integer.parseInt(outstanding);
            }
            this.regexes = HostRegexTableLoadBalancer.getRegexes(aconf);
            HashMap poolNameToRegexPatternBuilder = new HashMap();
            this.regexes.forEach((k, v) -> poolNameToRegexPatternBuilder.put(k, Pattern.compile(v)));
            this.poolNameToRegexPattern = Map.copyOf(poolNameToRegexPatternBuilder);
        }
    }
}

