/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.replication.FinishedWorkUpdater;
import org.apache.accumulo.manager.replication.RemoveCompleteReplicationRecords;
import org.apache.accumulo.manager.replication.StatusMaker;
import org.apache.accumulo.manager.replication.WorkMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplicationDriver
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReplicationDriver.class);
    private final Manager manager;
    private final AccumuloConfiguration conf;
    private WorkMaker workMaker;
    private StatusMaker statusMaker;
    private FinishedWorkUpdater finishedWorkUpdater;
    private RemoveCompleteReplicationRecords rcrr;
    private AccumuloClient client;

    public ReplicationDriver(Manager manager) {
        this.manager = manager;
        this.conf = manager.getConfiguration();
    }

    @Override
    public void run() {
        long millisToWait = this.conf.getTimeInMillis(Property.REPLICATION_DRIVER_DELAY);
        log.debug("Waiting {}ms before starting main replication loop", (Object)millisToWait);
        UtilWaitThread.sleep((long)millisToWait);
        log.debug("Starting replication loop");
        while (this.manager.stillManager()) {
            if (this.workMaker == null) {
                this.client = this.manager.getContext();
                this.statusMaker = new StatusMaker(this.client, this.manager.getVolumeManager());
                this.workMaker = new WorkMaker(this.manager.getContext(), this.client);
                this.finishedWorkUpdater = new FinishedWorkUpdater(this.client);
                this.rcrr = new RemoveCompleteReplicationRecords(this.client);
            }
            Span span = TraceUtil.startSpan(this.getClass(), (String)"managerReplicationDriver");
            try (Scope scope = span.makeCurrent();){
                try {
                    this.statusMaker.run();
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                    log.error("Caught Exception trying to create Replication status records", (Throwable)e);
                }
                try {
                    this.workMaker.run();
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                    log.error("Caught Exception trying to create Replication work records", (Throwable)e);
                }
                try {
                    this.finishedWorkUpdater.run();
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                    log.error("Caught Exception trying to update Replication records using finished work records", (Throwable)e);
                }
                try {
                    this.rcrr.run();
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span, (Throwable)e, (boolean)false);
                    log.error("Caught Exception trying to remove finished Replication records", (Throwable)e);
                }
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            long sleepMillis = this.conf.getTimeInMillis(Property.MANAGER_REPLICATION_SCAN_INTERVAL);
            log.trace("Sleeping for {}ms before re-running", (Object)sleepMillis);
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                log.error("Interrupted while sleeping", (Throwable)e);
            }
        }
    }
}

