/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import java.util.concurrent.Callable;

class TraceWrappedCallable<V>
implements Callable<V> {
    private final Context context = Context.current();
    private final Callable<V> unwrapped;

    static <C> Callable<C> unwrapFully(Callable<C> c) {
        while (c instanceof TraceWrappedCallable) {
            c = ((TraceWrappedCallable)c).unwrapped;
        }
        return c;
    }

    TraceWrappedCallable(Callable<V> other) {
        this.unwrapped = TraceWrappedCallable.unwrapFully(other);
    }

    @Override
    public V call() throws Exception {
        try (Scope unused = this.context.makeCurrent();){
            V v = this.unwrapped.call();
            return v;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TraceWrappedCallable) {
            return Objects.equals(this.unwrapped, ((TraceWrappedCallable)obj).unwrapped);
        }
        return false;
    }

    public int hashCode() {
        return this.unwrapped.hashCode();
    }
}

