/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.cleaner;

import java.lang.ref.Cleaner;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.slf4j.Logger;

public class CleanerUtil {
    public static final Cleaner CLEANER = Cleaner.create();

    public static Cleaner.Cleanable unclosed(AutoCloseable obj, Class<?> objClass, AtomicBoolean closed, Logger log, AutoCloseable closeable) {
        String className = Objects.requireNonNull(objClass).getSimpleName();
        Objects.requireNonNull(closed);
        Objects.requireNonNull(log);
        String closeableClassName = closeable == null ? null : closeable.getClass().getSimpleName();
        Exception stackTrace = new Exception();
        return CLEANER.register(obj, () -> {
            if (closed.get()) {
                return;
            }
            log.warn("{} found unreferenced without calling close()", (Object)className, (Object)stackTrace);
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e1) {
                    log.error("{} internal error; exception closing {}", new Object[]{objClass, closeableClassName, e1});
                }
            }
        });
    }

    public static Cleaner.Cleanable shutdownThreadPoolExecutor(ExecutorService pool, AtomicBoolean closed, Logger log) {
        Objects.requireNonNull(pool);
        Objects.requireNonNull(log);
        return CLEANER.register(pool, () -> {
            if (closed.get()) {
                return;
            }
            log.warn("{} found unreferenced without calling shutdown() or shutdownNow()", (Object)pool.getClass().getSimpleName());
            try {
                pool.shutdownNow();
            }
            catch (Exception e) {
                log.error("internal error; exception closing {}", (Object)pool.getClass().getSimpleName(), (Object)e);
            }
        });
    }

    public static Cleaner.Cleanable batchWriterAndClientCloser(Object o, Logger log, BatchWriter bw, AccumuloClient client) {
        Objects.requireNonNull(log);
        Objects.requireNonNull(bw);
        Objects.requireNonNull(client);
        return CLEANER.register(o, () -> {
            try (AccumuloClient accumuloClient = client;){
                bw.close();
            }
            catch (MutationsRejectedException e) {
                log.error("Failed to close BatchWriter; some mutations may not be applied", (Throwable)e);
            }
        });
    }
}

