/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.HdrHistogram.SingleWriterRecorder;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;

public final class RecordingMessageListener
implements MessageListener {
    private final long id;
    private final Destination destination;
    private final boolean transaction;
    private final AtomicLong receivedMessages;
    private final Runnable onMessageReceived;
    private final MicrosTimeProvider timeProvider;
    private final SingleWriterRecorder receiveLatencyRecorder;
    private AtomicBoolean fatalException;

    RecordingMessageListener(long id, Destination destination, boolean transaction, AtomicLong receivedMessages, Runnable onMessageReceived, MicrosTimeProvider timeProvider, SingleWriterRecorder receiveLatencyRecorder, AtomicBoolean fatalException) {
        this.id = id;
        this.destination = destination;
        this.transaction = transaction;
        this.receivedMessages = receivedMessages;
        this.onMessageReceived = onMessageReceived;
        this.timeProvider = timeProvider;
        this.receiveLatencyRecorder = receiveLatencyRecorder;
        this.fatalException = fatalException;
    }

    public boolean anyFatalException() {
        return this.fatalException.get();
    }

    public SingleWriterRecorder getReceiveLatencyRecorder() {
        return this.receiveLatencyRecorder;
    }

    public long getId() {
        return this.id;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public long getReceivedMessages() {
        return this.receivedMessages.get();
    }

    public void onMessage(Message message) {
        if (this.onMessageReceived != null) {
            this.onMessageReceived.run();
        }
        this.receivedMessages.lazySet(this.receivedMessages.get() + 1L);
        if (this.receiveLatencyRecorder != null) {
            try {
                long start = message.getLongProperty("time");
                long receivedOn = this.timeProvider.now();
                long elapsedUs = receivedOn - start;
                this.receiveLatencyRecorder.recordValue(elapsedUs);
            }
            catch (JMSException fatal) {
                this.fatalException.compareAndSet(false, true);
            }
        }
        if (this.transaction) {
            try {
                message.acknowledge();
            }
            catch (JMSException fatal) {
                this.fatalException.compareAndSet(false, true);
            }
        }
    }
}

