/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.util.Map;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounterSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AvgMinMaxPercentileCounterSetTest
extends ZKTestCase {
    private AvgMinMaxPercentileCounterSet testCounterSet;

    @BeforeEach
    public void initCounter() {
        this.testCounterSet = new AvgMinMaxPercentileCounterSet("test");
    }

    private void addDataPoints() {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.testCounterSet.add("key1", (long)i);
        }
        for (i = 1000; i < 2000; ++i) {
            this.testCounterSet.add("key2", (long)i);
        }
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounterSet.reset();
        Map values = this.testCounterSet.values();
        Assertions.assertEquals((Object)0.0, values.get("avg_key1_test"), (String)"avg_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("min_key1_test"), (String)"min_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("max_key1_test"), (String)"max_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("cnt_key1_test"), (String)"cnt_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("sum_key1_test"), (String)"sum_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("p50_key1_test"), (String)"p50_key1_test should have p50=0");
        Assertions.assertEquals((Object)0L, values.get("p95_key1_test"), (String)"p95_key1_test should have p95=0");
        Assertions.assertEquals((Object)0L, values.get("p99_key1_test"), (String)"p99_key1_test should have p99=0");
        Assertions.assertEquals((Object)0L, values.get("p999_key1_test"), (String)"p999_key1_test should have p999=0");
        Assertions.assertEquals((Object)0.0, values.get("avg_key2_test"), (String)"avg_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("min_key2_test"), (String)"min_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("max_key2_test"), (String)"max_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("cnt_key2_test"), (String)"cnt_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("sum_key2_test"), (String)"sum_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("p50_key2_test"), (String)"p50_key2_test should have p50=0");
        Assertions.assertEquals((Object)0L, values.get("p95_key2_test"), (String)"p95_key2_test should have p95=0");
        Assertions.assertEquals((Object)0L, values.get("p99_key2_test"), (String)"p99_key2_test should have p99=0");
        Assertions.assertEquals((Object)0L, values.get("p999_key2_test"), (String)"p999_key2_test should have p999=0");
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map values = this.testCounterSet.values();
        Assertions.assertEquals((int)18, (int)values.size(), (String)"There should be 18 values in the set");
        Assertions.assertEquals((Object)499.5, values.get("avg_key1_test"), (String)"avg_key1_test should =499.5");
        Assertions.assertEquals((Object)0L, values.get("min_key1_test"), (String)"min_key1_test should =0");
        Assertions.assertEquals((Object)999L, values.get("max_key1_test"), (String)"max_key1_test should =999");
        Assertions.assertEquals((Object)1000L, values.get("cnt_key1_test"), (String)"cnt_key1_test should =1000");
        Assertions.assertEquals((Object)499500L, values.get("sum_key1_test"), (String)"sum_key1_test should =999*500");
        Assertions.assertEquals((Object)500L, values.get("p50_key1_test"), (String)"p50_key1_test should have p50=500");
        Assertions.assertEquals((Object)950L, values.get("p95_key1_test"), (String)"p95_key1_test should have p95=950");
        Assertions.assertEquals((Object)990L, values.get("p99_key1_test"), (String)"p99_key1_test should have p99=990");
        Assertions.assertEquals((Object)999L, values.get("p999_key1_test"), (String)"p999_key1_test should have p999=999");
        Assertions.assertEquals((Object)1499.5, values.get("avg_key2_test"), (String)"avg_key2_test should =3.5");
        Assertions.assertEquals((Object)1000L, values.get("min_key2_test"), (String)"min_key2_test should =2");
        Assertions.assertEquals((Object)1999L, values.get("max_key2_test"), (String)"max_key2_test should =5");
        Assertions.assertEquals((Object)1000L, values.get("cnt_key2_test"), (String)"cnt_key2_test should =4");
        Assertions.assertEquals((Object)1499500L, values.get("sum_key2_test"), (String)"sum_key2_test should =14");
        Assertions.assertEquals((Object)1500L, values.get("p50_key2_test"), (String)"p50_key2_test should have p50=1500");
        Assertions.assertEquals((Object)1950L, values.get("p95_key2_test"), (String)"p95_key2_test should have p95=1950");
        Assertions.assertEquals((Object)1990L, values.get("p99_key2_test"), (String)"p99_key2_test should have p99=1990");
        Assertions.assertEquals((Object)1999L, values.get("p999_key2_test"), (String)"p999_key2_test should have p999=1999");
    }
}

