/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.namespace;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.AdminCommand;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class GetNamespaceCommand
extends AdminCommand<Flags> {
    private static final String NAME = "get";
    private static final String DESC = "Get the details of a namespace";

    public GetNamespaceCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<namespace-name>").build());
    }

    @Override
    protected void run(StorageAdminClient admin, BKFlags globalFlags, Flags cmdFlags) throws Exception {
        Preconditions.checkArgument((!cmdFlags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"Namespace name is not provided");
        String namespaceName = (String)cmdFlags.arguments.get(0);
        try {
            NamespaceProperties ns = (NamespaceProperties)FutureUtils.result((CompletableFuture)admin.getNamespace(namespaceName));
            this.spec.console().println("Namespace '" + namespaceName + "' :");
            this.spec.console().println(ns);
        }
        catch (NamespaceNotFoundException nfe) {
            this.spec.console().println("Namespace '" + namespaceName + "' does not exist");
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

