/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] ZERO_BYTE = new byte[1];
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    CSHAKEDigest(int n, byte[] byArray, byte[] byArray2) {
        super(n);
        if (n == 128) {
            SelfTestExecutor.validate(FipsSHS.Algorithm.cSHAKE128, this, new KatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba7")));
        } else {
            SelfTestExecutor.validate(FipsSHS.Algorithm.cSHAKE256, this, new KatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739")));
        }
        if (!(byArray != null && byArray.length != 0 || byArray2 != null && byArray2.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(CSHAKEDigest.leftEncode(this.rate / 8), this.encodeString(byArray), this.encodeString(byArray2));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int n;
        int n2 = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length * 8);
        for (n = (n2 - this.diff.length % n2) % n2; n > padding.length; n -= padding.length) {
            this.absorb(padding, 0, padding.length * 8);
        }
        this.absorb(padding, 0, n * 8);
    }

    private byte[] encodeString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return CSHAKEDigest.leftEncode(0L);
        }
        return Arrays.concatenate(CSHAKEDigest.leftEncode((long)byArray.length * 8L), byArray);
    }

    private static byte[] leftEncode(long l) {
        int n = 1;
        long l2 = l;
        while ((l2 >>= 8) != 0L) {
            n = (byte)(n + 1);
        }
        byte[] byArray = new byte[n + 1];
        byArray[0] = n;
        for (int i = 1; i <= n; ++i) {
            byArray[i] = (byte)(l >> 8 * (n - i));
        }
        return byArray;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorb(ZERO_BYTE, 0, 2L);
            }
            this.squeeze(byArray, n, (long)n2 * 8L);
            return n2;
        }
        return super.doOutput(byArray, n, n2);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        KatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            digest.reset();
            return Arrays.areEqual(byArray, this.kat);
        }
    }
}

