/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	scheme "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// BuildsGetter has a method to return a BuildInterface.
// A group's client should implement this interface.
type BuildsGetter interface {
	Builds(namespace string) BuildInterface
}

// BuildInterface has methods to work with Build resources.
type BuildInterface interface {
	Create(ctx context.Context, build *camelv1.Build, opts metav1.CreateOptions) (*camelv1.Build, error)
	Update(ctx context.Context, build *camelv1.Build, opts metav1.UpdateOptions) (*camelv1.Build, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, build *camelv1.Build, opts metav1.UpdateOptions) (*camelv1.Build, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*camelv1.Build, error)
	List(ctx context.Context, opts metav1.ListOptions) (*camelv1.BuildList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *camelv1.Build, err error)
	Apply(ctx context.Context, build *applyconfigurationcamelv1.BuildApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.Build, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, build *applyconfigurationcamelv1.BuildApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.Build, err error)
	BuildExpansion
}

// builds implements BuildInterface
type builds struct {
	*gentype.ClientWithListAndApply[*camelv1.Build, *camelv1.BuildList, *applyconfigurationcamelv1.BuildApplyConfiguration]
}

// newBuilds returns a Builds
func newBuilds(c *CamelV1Client, namespace string) *builds {
	return &builds{
		gentype.NewClientWithListAndApply[*camelv1.Build, *camelv1.BuildList, *applyconfigurationcamelv1.BuildApplyConfiguration](
			"builds",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *camelv1.Build { return &camelv1.Build{} },
			func() *camelv1.BuildList { return &camelv1.BuildList{} },
		),
	}
}
