/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SequentialWriter
extends BufferedDataOutputStreamPlus
implements Transactional {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private final String filePath;
    protected long bufferOffset;
    protected final FileChannel fchannel;
    private boolean trickleFsync;
    private int trickleFsyncByteInterval;
    private int bytesSinceTrickleFsync = 0;
    protected long lastFlushOffset;
    protected Runnable runPostFlush;
    private final TransactionalProxy txnProxy = this.txnProxy();
    private boolean finishOnClose;
    protected Descriptor descriptor;

    private static FileChannel openChannel(File file) {
        try {
            if (file.exists()) {
                return FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            try {
                SyncUtil.trySyncDir((File)file.getParentFile());
            }
            catch (Throwable t) {
                try {
                    channel.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
            }
            return channel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SequentialWriter(File file, int bufferSize, BufferType bufferType) {
        super((WritableByteChannel)SequentialWriter.openChannel(file), bufferType.allocate(bufferSize));
        this.strictFlushing = true;
        this.fchannel = (FileChannel)this.channel;
        this.filePath = file.getAbsolutePath();
        this.trickleFsync = DatabaseDescriptor.getTrickleFsync();
        this.trickleFsyncByteInterval = DatabaseDescriptor.getTrickleFsyncIntervalInKb() * 1024;
    }

    public static SequentialWriter open(File file) {
        return new SequentialWriter(file, 65536, BufferType.ON_HEAP);
    }

    public static ChecksummedSequentialWriter open(File file, File crcPath) {
        return new ChecksummedSequentialWriter(file, 65536, crcPath);
    }

    public static CompressedSequentialWriter open(String dataFilePath, String offsetsPath, CompressionParams parameters, MetadataCollector sstableMetadataCollector) {
        return new CompressedSequentialWriter(new File(dataFilePath), offsetsPath, parameters, sstableMetadataCollector);
    }

    public SequentialWriter finishOnClose() {
        this.finishOnClose = true;
        return this;
    }

    public void sync() {
        this.syncInternal();
    }

    protected void syncDataOnlyInternal() {
        try {
            SyncUtil.force((FileChannel)this.fchannel, (boolean)false);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    protected void syncInternal() {
        this.doFlush(0);
        this.syncDataOnlyInternal();
    }

    @Override
    protected void doFlush(int count) {
        this.flushData();
        if (this.trickleFsync) {
            this.bytesSinceTrickleFsync += this.buffer.position();
            if (this.bytesSinceTrickleFsync >= this.trickleFsyncByteInterval) {
                this.syncDataOnlyInternal();
                this.bytesSinceTrickleFsync = 0;
            }
        }
        this.resetBuffer();
    }

    public void setPostFlushListener(Runnable runPostFlush) {
        assert (this.runPostFlush == null);
        this.runPostFlush = runPostFlush;
    }

    protected void flushData() {
        try {
            this.buffer.flip();
            this.channel.write(this.buffer);
            this.lastFlushOffset += (long)this.buffer.position();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        if (this.runPostFlush != null) {
            this.runPostFlush.run();
        }
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public long position() {
        return this.current();
    }

    public long getOnDiskFilePointer() {
        return this.position();
    }

    public long length() {
        try {
            return Math.max(this.current(), this.fchannel.size());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    public String getPath() {
        return this.filePath;
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current();
        this.buffer.clear();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    public DataPosition mark() {
        return new BufferedFileWriterMark(this.current());
    }

    public void resetAndTruncate(DataPosition mark) {
        long truncateTarget;
        assert (mark instanceof BufferedFileWriterMark);
        long previous = this.current();
        if (previous - (truncateTarget = ((BufferedFileWriterMark)mark).pointer) <= (long)this.buffer.position()) {
            this.buffer.position(this.buffer.position() - (int)(previous - truncateTarget));
            return;
        }
        this.syncInternal();
        this.truncate(truncateTarget);
        try {
            this.fchannel.position(truncateTarget);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.bufferOffset = truncateTarget;
        this.resetBuffer();
    }

    public long getLastFlushOffset() {
        return this.lastFlushOffset;
    }

    public void truncate(long toSize) {
        try {
            this.fchannel.truncate(toSize);
            this.lastFlushOffset = toSize;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SequentialWriter setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    public final Throwable commit(Throwable accumulate) {
        return this.txnProxy.commit(accumulate);
    }

    public final Throwable abort(Throwable accumulate) {
        return this.txnProxy.abort(accumulate);
    }

    @Override
    public final void close() {
        if (this.finishOnClose) {
            this.txnProxy.finish();
        } else {
            this.txnProxy.close();
        }
    }

    public final void finish() {
        this.txnProxy.finish();
    }

    protected TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    protected static class BufferedFileWriterMark
    implements DataPosition {
        final long pointer;

        public BufferedFileWriterMark(long pointer) {
            this.pointer = pointer;
        }
    }

    protected class TransactionalProxy
    extends Transactional.AbstractTransactional {
        protected TransactionalProxy() {
        }

        protected Throwable doPreCleanup(Throwable accumulate) {
            try {
                SequentialWriter.this.channel.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge((Throwable)accumulate, (Throwable)t);
            }
            if (SequentialWriter.this.buffer != null) {
                try {
                    FileUtils.clean(SequentialWriter.this.buffer);
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge((Throwable)accumulate, (Throwable)t);
                }
                SequentialWriter.this.buffer = null;
            }
            return accumulate;
        }

        protected void doPrepare() {
            SequentialWriter.this.syncInternal();
        }

        protected Throwable doCommit(Throwable accumulate) {
            return accumulate;
        }

        protected Throwable doAbort(Throwable accumulate) {
            return accumulate;
        }
    }
}

