/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.job;

import com.datastax.driver.core.utils.UUIDs;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.server.exceptions.OperationalJobException;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationalJob
implements Task<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationalJob.class);
    private final UUID jobId;
    private final Promise<Void> executionPromise;
    private volatile boolean isExecuting = false;

    protected OperationalJob(UUID jobId) {
        Preconditions.checkArgument((jobId.version() == 1 ? 1 : 0) != 0, (String)"OperationalJob accepts only time-based UUID");
        this.jobId = jobId;
        this.executionPromise = Promise.promise();
    }

    public UUID jobId() {
        return this.jobId;
    }

    @Override
    public final Void result() {
        throw new UnsupportedOperationException("No result is expected from an OperationalJob");
    }

    public long creationTime() {
        return UUIDs.unixTimestamp((UUID)this.jobId);
    }

    public boolean isExecuting() {
        return this.isExecuting;
    }

    public boolean isStale(long referenceTimestampInMillis, long ttlInMillis) {
        long createdAt = this.creationTime();
        Preconditions.checkArgument((referenceTimestampInMillis >= createdAt ? 1 : 0) != 0, (String)"Invalid referenceTimestampInMillis");
        Preconditions.checkArgument((ttlInMillis >= 0L ? 1 : 0) != 0, (String)"Invalid ttlInMillis");
        return referenceTimestampInMillis - createdAt > ttlInMillis;
    }

    public abstract boolean isRunningOnCassandra();

    public OperationalJobStatus status() {
        Future<Void> fut = this.asyncResult();
        if (!this.isExecuting && !fut.isComplete()) {
            return OperationalJobStatus.CREATED;
        }
        if (!fut.isComplete()) {
            return OperationalJobStatus.RUNNING;
        }
        if (fut.failed()) {
            return OperationalJobStatus.FAILED;
        }
        return OperationalJobStatus.SUCCEEDED;
    }

    public Future<Void> asyncResult() {
        return this.executionPromise.future();
    }

    public Future<Void> asyncResult(TaskExecutorPool executorPool, DurationSpec waitTime) {
        Future<Void> resultFut = this.asyncResult();
        if (resultFut.isComplete()) {
            return resultFut;
        }
        Promise maxWaitTimePromise = Promise.promise();
        executorPool.setTimer(waitTime.toMillis(), (Handler<Long>)((Handler)d -> maxWaitTimePromise.tryComplete((Object)true)));
        resultFut.onComplete(res -> maxWaitTimePromise.tryComplete((Object)false));
        Future maxWaitTimeFut = maxWaitTimePromise.future();
        return Future.any((Future)maxWaitTimeFut, resultFut).compose(f -> {
            boolean isTimeout = (Boolean)maxWaitTimeFut.result();
            if (isTimeout) {
                return Future.succeededFuture();
            }
            return resultFut;
        });
    }

    protected abstract void executeInternal();

    @Override
    public void execute(Promise<Void> promise) {
        this.isExecuting = true;
        LOGGER.info("Executing job. jobId={}", (Object)this.jobId);
        promise.future().onComplete(this.executionPromise);
        try {
            this.executeInternal();
            promise.tryComplete();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Complete job execution. jobId={} status={}", (Object)this.jobId, (Object)this.status());
            }
        }
        catch (Throwable e) {
            OperationalJobException oje = OperationalJobException.wraps((Throwable)e);
            LOGGER.error("Job execution failed. jobId={} reason='{}'", new Object[]{this.jobId, oje.getMessage(), oje});
            promise.tryFail((Throwable)oje);
        }
    }
}

