/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.tasks;

import com.codahale.metrics.DefaultSettableGauge;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.PeriodicTaskConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.metrics.server.HealthMetrics;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckPeriodicTask
implements PeriodicTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckPeriodicTask.class);
    private final PeriodicTaskConfiguration configuration;
    private final InstancesMetadata instancesMetadata;
    private final TaskExecutorPool internalPool;
    private final HealthMetrics metrics;

    public HealthCheckPeriodicTask(SidecarConfiguration configuration, InstancesMetadata instancesMetadata, ExecutorPools executorPools, SidecarMetrics metrics) {
        this.configuration = configuration.healthCheckConfiguration();
        this.instancesMetadata = instancesMetadata;
        this.internalPool = executorPools.internal();
        this.metrics = metrics.server().health();
    }

    @Override
    public DurationSpec initialDelay() {
        return this.configuration.initialDelay();
    }

    @Override
    public DurationSpec delay() {
        return this.configuration.executeInterval();
    }

    @Override
    public void execute(Promise<Void> promise) {
        AtomicInteger instanceDown = new AtomicInteger(0);
        List futures = this.instancesMetadata.instances().stream().map(instanceMetadata -> this.healthCheck((InstanceMetadata)instanceMetadata, instanceDown)).collect(Collectors.toList());
        Future.join(futures).onComplete(v -> this.updateMetrics(instanceDown)).onSuccess(v -> promise.complete()).onFailure(arg_0 -> promise.fail(arg_0));
    }

    @Override
    public String name() {
        return "Health Check";
    }

    private void updateMetrics(AtomicInteger instanceDown) {
        int instanceDownCount = instanceDown.get();
        int instanceUpCount = this.instancesMetadata.instances().size() - instanceDownCount;
        ((DefaultSettableGauge)this.metrics.cassandraInstancesUp.metric).setValue((Object)instanceUpCount);
        ((DefaultSettableGauge)this.metrics.cassandraInstancesDown.metric).setValue((Object)instanceDownCount);
    }

    private Future<Void> healthCheck(InstanceMetadata instanceMetadata, AtomicInteger instanceDown) {
        return this.internalPool.runBlocking(() -> instanceMetadata.delegate().healthCheck(), false).onFailure(cause -> {
            instanceDown.incrementAndGet();
            LOGGER.error("Unable to complete health check on instance={}", (Object)instanceMetadata.id(), cause);
        });
    }
}

