/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.handler.HttpException;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;

public class HttpExceptions {
    private HttpExceptions() {
    }

    public static HttpException wrapHttpException(HttpResponseStatus status, Throwable cause) {
        return HttpExceptions.wrapHttpException(status, null, cause);
    }

    public static HttpException wrapHttpException(HttpResponseStatus status, String payload) {
        return HttpExceptions.wrapHttpException(status, payload, null);
    }

    public static HttpException wrapHttpException(HttpResponseStatus status, String payload, Throwable cause) {
        if (cause instanceof HttpException) {
            return (HttpException)cause;
        }
        if (cause instanceof CassandraUnavailableException) {
            String actualPayload = payload == null ? cause.getMessage() : payload;
            return new HttpException(HttpResponseStatus.SERVICE_UNAVAILABLE.code(), actualPayload, cause);
        }
        if (payload != null) {
            return new HttpException(status.code(), payload, cause);
        }
        return new HttpException(status.code(), "Unexpected error encountered in handler", cause);
    }
}

