/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.EnhancedDoubleHasher;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;

public class TestingHashers {
    public static final Hasher FROM1 = new IncrementingHasher(1L, 1L);
    public static final Hasher FROM11 = new IncrementingHasher(11L, 1L);

    public static <T extends BloomFilter> T mergeHashers(T filter, Hasher ... hashers) {
        for (Hasher h : hashers) {
            filter.merge(h);
        }
        return filter;
    }

    public static <T extends BloomFilter> T populateEntireFilter(T filter) {
        return TestingHashers.populateRange(filter, 0, filter.getShape().getNumberOfBits() - 1);
    }

    public static <T extends BloomFilter> T populateFromHashersFrom1AndFrom11(T filter) {
        return TestingHashers.mergeHashers(filter, FROM1, FROM11);
    }

    public static <T extends BloomFilter> T populateRange(T filter, int start, int end) {
        filter.merge(p -> {
            for (int i = start; i <= end; ++i) {
                if (p.test(i)) continue;
                return false;
            }
            return true;
        });
        return filter;
    }

    public static Hasher randomHasher() {
        return new EnhancedDoubleHasher(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    private TestingHashers() {
    }
}

