/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.threed.AbstractPlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.ConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.EmbeddedAreaPlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Planes;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Lines3D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.numbers.core.Precision;

abstract class AbstractConvexPolygon3D
extends AbstractPlaneSubset
implements ConvexPolygon3D {
    private final Plane plane;

    AbstractConvexPolygon3D(Plane plane) {
        this.plane = plane;
    }

    @Override
    public Plane getPlane() {
        return this.plane;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public double getSize() {
        List vertices = this.getVertices();
        double crossSumX = 0.0;
        double crossSumY = 0.0;
        double crossSumZ = 0.0;
        Vector3D prevPt = (Vector3D)vertices.get(vertices.size() - 1);
        for (Vector3D curPt : vertices) {
            Vector3D cross = prevPt.cross(curPt);
            crossSumX += cross.getX();
            crossSumY += cross.getY();
            crossSumZ += cross.getZ();
            prevPt = curPt;
        }
        return 0.5 * this.plane.getNormal().dot(Vector3D.of(crossSumX, crossSumY, crossSumZ));
    }

    public Vector3D getCentroid() {
        List vertices = this.getVertices();
        double areaSum = 0.0;
        double scaledCentroidSumX = 0.0;
        double scaledCentroidSumY = 0.0;
        double scaledCentroidSumZ = 0.0;
        Iterator it = vertices.iterator();
        Vector3D startPt = (Vector3D)it.next();
        Vector3D prevPt = (Vector3D)it.next();
        Vector3D prevVec = startPt.vectorTo(prevPt);
        while (it.hasNext()) {
            Vector3D curPt = (Vector3D)it.next();
            Vector3D curVec = startPt.vectorTo(curPt);
            double triArea = 0.5 * prevVec.cross(curVec).norm();
            Vector3D triCentroid = Vector3D.centroid(startPt, prevPt, curPt);
            areaSum += triArea;
            scaledCentroidSumX += triArea * triCentroid.getX();
            scaledCentroidSumY += triArea * triCentroid.getY();
            scaledCentroidSumZ += triArea * triCentroid.getZ();
            prevPt = curPt;
            prevVec = curVec;
        }
        if (areaSum > 0.0) {
            double scale = 1.0 / areaSum;
            return Vector3D.of(scale * scaledCentroidSumX, scale * scaledCentroidSumY, scale * scaledCentroidSumZ);
        }
        Vector3D min = Vector3D.min(vertices);
        Vector3D max = Vector3D.max(vertices);
        return min.lerp(max, 0.5);
    }

    @Override
    public Bounds3D getBounds() {
        return Bounds3D.from(this.getVertices());
    }

    public RegionLocation classify(Vector3D pt) {
        if (this.plane.contains(pt)) {
            List vertices = this.getVertices();
            Precision.DoubleEquivalence precision = this.plane.getPrecision();
            Vector3D.Unit normal = this.plane.getNormal();
            boolean onBoundary = false;
            Vector3D startVertex = (Vector3D)vertices.get(vertices.size() - 1);
            for (Vector3D nextVertex : vertices) {
                Vector3D edgeVec = startVertex.vectorTo(nextVertex);
                Vector3D edgePlusVec = edgeVec.cross(normal);
                Vector3D testVec = startVertex.vectorTo(pt);
                Vector3D offsetVec = testVec.reject(edgeVec);
                double offsetSign = Math.signum(offsetVec.dot(edgePlusVec));
                double offset = offsetSign * offsetVec.norm();
                int cmp = precision.compare(offset, 0.0);
                if (cmp > 0) {
                    return RegionLocation.OUTSIDE;
                }
                if (cmp == 0) {
                    onBoundary = true;
                }
                startVertex = nextVertex;
            }
            if (onBoundary) {
                return RegionLocation.BOUNDARY;
            }
            return RegionLocation.INSIDE;
        }
        return RegionLocation.OUTSIDE;
    }

    public Vector3D closest(Vector3D pt) {
        Vector3D.Unit normal = this.plane.getNormal();
        Precision.DoubleEquivalence precision = this.plane.getPrecision();
        List vertices = this.getVertices();
        Vector3D projPt = this.plane.project(pt);
        double closestBoundaryPointDistSq = Double.POSITIVE_INFINITY;
        Vector3D closestBoundaryPoint = null;
        Vector3D startVertex = (Vector3D)vertices.get(vertices.size() - 1);
        for (Vector3D nextVertex : vertices) {
            Vector3D edgeVec = startVertex.vectorTo(nextVertex);
            Vector3D edgePlusVec = edgeVec.cross(normal);
            Vector3D testVec = startVertex.vectorTo(projPt);
            Vector3D offsetVec = testVec.reject(edgeVec);
            double offsetSign = Math.signum(offsetVec.dot(edgePlusVec));
            double offset = offsetSign * offsetVec.norm();
            int cmp = precision.compare(offset, 0.0);
            if (cmp >= 0) {
                Vector3D boundaryVec = testVec.subtract(offsetVec);
                double boundaryPointT = Math.signum(boundaryVec.dot(edgeVec)) * (boundaryVec.norm() / Vectors.checkedNorm(edgeVec));
                Vector3D boundaryPoint = startVertex.lerp(nextVertex, boundaryPointT = Math.max(0.0, Math.min(1.0, boundaryPointT)));
                double boundaryPointDistSq = boundaryPoint.distanceSq(projPt);
                if (boundaryPointDistSq < closestBoundaryPointDistSq) {
                    closestBoundaryPointDistSq = boundaryPointDistSq;
                    closestBoundaryPoint = boundaryPoint;
                }
            }
            startVertex = nextVertex;
        }
        if (closestBoundaryPoint != null) {
            return closestBoundaryPoint;
        }
        return projPt;
    }

    @Override
    public PlaneConvexSubset.Embedded getEmbedded() {
        EmbeddingPlane embeddingPlane = this.plane.getEmbedding();
        List subspaceVertices = embeddingPlane.toSubspace(this.getVertices());
        ConvexArea area = ConvexArea.convexPolygonFromVertices(subspaceVertices, embeddingPlane.getPrecision());
        return new EmbeddedAreaPlaneConvexSubset(embeddingPlane, area);
    }

    @Override
    public Split<PlaneConvexSubset> split(Hyperplane<Vector3D> splitter) {
        Plane splitterPlane = (Plane)splitter;
        List vertices = this.getVertices();
        int size = vertices.size();
        int minusPlusTransitionIdx = -1;
        Vector3D minusPlusInsertVertex = null;
        int plusMinusTransitionIdx = -1;
        Vector3D plusMinusInsertVertex = null;
        int transitionCount = 0;
        int lastSideIdx = -1;
        Vector3D lastSideVertex = null;
        HyperplaneLocation lastSideLoc = null;
        int lastBoundaryIdx = -1;
        for (int i = 0; i <= size || transitionCount == 1; ++i) {
            Vector3D curVertex = (Vector3D)vertices.get(i % size);
            HyperplaneLocation curLoc = splitter.classify((Point)curVertex);
            if (lastSideLoc == HyperplaneLocation.MINUS && curLoc == HyperplaneLocation.PLUS) {
                minusPlusTransitionIdx = Math.max(lastSideIdx, lastBoundaryIdx);
                ++transitionCount;
                if (lastBoundaryIdx < 0) {
                    minusPlusInsertVertex = splitterPlane.intersection(Lines3D.fromPoints(lastSideVertex, curVertex, splitterPlane.getPrecision()));
                }
            } else if (lastSideLoc == HyperplaneLocation.PLUS && curLoc == HyperplaneLocation.MINUS) {
                plusMinusTransitionIdx = Math.max(lastSideIdx, lastBoundaryIdx);
                ++transitionCount;
                if (lastBoundaryIdx < 0) {
                    plusMinusInsertVertex = splitterPlane.intersection(Lines3D.fromPoints(lastSideVertex, curVertex, splitterPlane.getPrecision()));
                }
            }
            if (curLoc == HyperplaneLocation.ON) {
                lastBoundaryIdx = i;
                continue;
            }
            lastBoundaryIdx = -1;
            lastSideIdx = i;
            lastSideVertex = curVertex;
            lastSideLoc = curLoc;
        }
        if (minusPlusTransitionIdx > -1 && plusMinusTransitionIdx > -1) {
            List<Vector3D> minusVertices = this.buildPolygonSplitVertexList(plusMinusTransitionIdx, plusMinusInsertVertex, minusPlusTransitionIdx, minusPlusInsertVertex, vertices);
            List<Vector3D> plusVertices = this.buildPolygonSplitVertexList(minusPlusTransitionIdx, minusPlusInsertVertex, plusMinusTransitionIdx, plusMinusInsertVertex, vertices);
            return new Split((Object)Planes.fromConvexPlanarVertices(this.plane, minusVertices), (Object)Planes.fromConvexPlanarVertices(this.plane, plusVertices));
        }
        if (lastSideLoc == HyperplaneLocation.PLUS) {
            return new Split(null, (Object)this);
        }
        if (lastSideLoc == HyperplaneLocation.MINUS) {
            return new Split((Object)this, null);
        }
        return new Split(null, null);
    }

    private List<Vector3D> buildPolygonSplitVertexList(int enterIdx, Vector3D newEnterPt, int exitIdx, Vector3D newExitPt, List<? extends Vector3D> vertices) {
        int size = vertices.size();
        boolean hasNewEnterPt = newEnterPt != null;
        boolean hasNewExitPt = newExitPt != null;
        int startIdx = (hasNewEnterPt ? enterIdx + 1 : enterIdx) % size;
        int endIdx = exitIdx % size;
        boolean hasWrappedIndices = endIdx < startIdx;
        int resultSize = (hasWrappedIndices ? endIdx + size : endIdx) - startIdx + 1;
        ArrayList<Vector3D> result = new ArrayList<Vector3D>(resultSize);
        if (hasNewEnterPt) {
            result.add(newEnterPt);
        }
        if (hasWrappedIndices) {
            result.addAll(vertices.subList(startIdx, size));
            result.addAll(vertices.subList(0, endIdx + 1));
        } else {
            result.addAll(vertices.subList(startIdx, endIdx + 1));
        }
        if (hasNewExitPt) {
            result.add(newExitPt);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[normal= ").append(this.getPlane().getNormal()).append(", vertices= ").append(this.getVertices()).append(']');
        return sb.toString();
    }
}

