/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.internal.EuclideanUtils;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.output.GeometryOutput;
import org.apache.commons.geometry.io.euclidean.threed.AbstractBoundaryWriteHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.GeometryFormat3D;
import org.apache.commons.geometry.io.euclidean.threed.stl.BinaryStlFacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.stl.BinaryStlWriter;

public class StlBoundaryWriteHandler3D
extends AbstractBoundaryWriteHandler3D {
    private static final int DEFAULT_BUFFER_SIZE = 51200;
    private int initialBufferSize = 51200;

    public GeometryFormat getFormat() {
        return GeometryFormat3D.STL;
    }

    public int getinitialBufferSize() {
        return this.initialBufferSize;
    }

    public void setInitialBufferSize(int initialBufferSize) {
        if (initialBufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        this.initialBufferSize = initialBufferSize;
    }

    @Override
    public void write(BoundarySource3D src, GeometryOutput out) {
        if (src instanceof TriangleMesh) {
            this.writeTriangleMesh((TriangleMesh)src, out);
        } else {
            super.write(src, out);
        }
    }

    @Override
    public void write(Stream<? extends PlaneConvexSubset> boundaries, GeometryOutput out) {
        int triangleCount = 0;
        ByteArrayOutputStream triangleBuffer = new ByteArrayOutputStream(this.initialBufferSize);
        try (BinaryStlWriter stlWriter = new BinaryStlWriter(triangleBuffer);){
            Iterator it = boundaries.iterator();
            while (it.hasNext()) {
                for (Triangle3D tri : ((PlaneConvexSubset)it.next()).toTriangles()) {
                    stlWriter.writeTriangle(tri.getPoint1(), tri.getPoint2(), tri.getPoint3(), (Vector3D)tri.getPlane().getNormal());
                    ++triangleCount;
                }
            }
        }
        this.writeWithHeader(triangleBuffer, triangleCount, out);
    }

    @Override
    public void writeFacets(Stream<? extends FacetDefinition> facets, GeometryOutput out) {
        int triangleCount = 0;
        ByteArrayOutputStream triangleBuffer = new ByteArrayOutputStream(this.initialBufferSize);
        try (BinaryStlWriter dataWriter = new BinaryStlWriter(triangleBuffer);){
            Iterator it = facets.iterator();
            while (it.hasNext()) {
                FacetDefinition facet = (FacetDefinition)it.next();
                int attributeValue = this.getFacetAttributeValue(facet);
                for (List tri : EuclideanUtils.convexPolygonToTriangleFan(facet.getVertices(), t -> t)) {
                    dataWriter.writeTriangle((Vector3D)tri.get(0), (Vector3D)tri.get(1), (Vector3D)tri.get(2), facet.getNormal(), attributeValue);
                    ++triangleCount;
                }
            }
        }
        this.writeWithHeader(triangleBuffer, triangleCount, out);
    }

    private void writeWithHeader(ByteArrayOutputStream triangleBuffer, int count, GeometryOutput out) {
        try (OutputStream os = out.getOutputStream();){
            BinaryStlWriter.writeHeader(null, count, os);
            triangleBuffer.writeTo(os);
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked((IOException)exc);
        }
    }

    private void writeTriangleMesh(TriangleMesh mesh, GeometryOutput output) {
        try (BinaryStlWriter stlWriter = new BinaryStlWriter(output.getOutputStream());){
            stlWriter.writeHeader(null, mesh.getFaceCount());
            for (TriangleMesh.Face face : mesh.faces()) {
                Triangle3D tri = face.getPolygon();
                stlWriter.writeTriangle(tri.getPoint1(), tri.getPoint2(), tri.getPoint3(), (Vector3D)tri.getPlane().getNormal());
            }
        }
    }

    private int getFacetAttributeValue(FacetDefinition facet) {
        if (facet instanceof BinaryStlFacetDefinition) {
            return ((BinaryStlFacetDefinition)facet).getAttributeValue();
        }
        return 0;
    }
}

