/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.channels.ByteArraySeekableByteChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ByteArraySeekableByteChannelCompressTest {
    private static final byte[] testData = "Some data".getBytes(StandardCharsets.UTF_8);

    ByteArraySeekableByteChannelCompressTest() {
    }

    @AfterEach
    void afterEach() {
        Assertions.assertArrayEquals((byte[])"Some data".getBytes(StandardCharsets.UTF_8), (byte[])testData);
    }

    @Test
    void testCloseIsIdempotent() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4, 5, 6})
    void testReadingFromAPositionAfterEndReturnsEOF(int size) throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])new byte[size]);){
            int position = 2;
            c.position(2L);
            Assertions.assertEquals((long)2L, (long)c.position());
            int readSize = 5;
            ByteBuffer readBuffer = ByteBuffer.allocate(5);
            Assertions.assertEquals((int)(2 >= size ? -1 : size - 2), (int)c.read(readBuffer));
        }
    }

    @Test
    void testShouldReadContentsProperly() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((int)testData.length, (int)readCount);
            Assertions.assertArrayEquals((byte[])testData, (byte[])readBuffer.array());
            Assertions.assertEquals((long)testData.length, (long)c.position());
        }
    }

    @Test
    void testShouldReadContentsWhenBiggerBufferSupplied() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length + 1);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((int)testData.length, (int)readCount);
            Assertions.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOf(readBuffer.array(), testData.length));
            Assertions.assertEquals((long)testData.length, (long)c.position());
        }
    }

    @Test
    void testShouldReadDataFromSetPosition() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(4);
            c.position(5L);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((long)4L, (long)readCount);
            Assertions.assertEquals((Object)"data", (Object)new String(readBuffer.array(), StandardCharsets.UTF_8));
            Assertions.assertEquals((long)testData.length, (long)c.position());
        }
    }

    @Test
    void testShouldSetProperPosition() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            long posAtFour = c.position(4L).position();
            long posAtTheEnd = c.position((long)testData.length).position();
            long posPastTheEnd = c.position((long)testData.length + 1L).position();
            Assertions.assertEquals((long)4L, (long)posAtFour);
            Assertions.assertEquals((long)c.size(), (long)posAtTheEnd);
            Assertions.assertEquals((long)((long)testData.length + 1L), (long)posPastTheEnd);
        }
    }

    @Test
    void testShouldSetProperPositionOnTruncate() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.position((long)testData.length);
            c.truncate(4L);
            Assertions.assertEquals((long)4L, (long)c.position());
            Assertions.assertEquals((long)4L, (long)c.size());
        }
    }

    @Test
    void testShouldSignalEOFWhenPositionAtTheEnd() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length);
            c.position((long)(testData.length + 1));
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((long)0L, (long)readBuffer.position());
            Assertions.assertEquals((int)-1, (int)readCount);
            Assertions.assertEquals((int)-1, (int)c.read(readBuffer));
        }
    }

    @Test
    void testShouldThrowExceptionOnReadingClosedChannel() {
        ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();
        c.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> c.read(ByteBuffer.allocate(1)));
    }

    @Test
    void testShouldThrowExceptionOnWritingToClosedChannel() {
        ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();
        c.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> c.write(ByteBuffer.allocate(1)));
    }

    @Test
    void testShouldThrowExceptionWhenSettingIncorrectPosition() {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.position(0x80000000L));
        }
    }

    @Test
    void testShouldThrowExceptionWhenTruncatingToIncorrectSize() {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.truncate(0x80000000L));
        }
    }

    @Test
    void testShouldTruncateContentsProperly() throws ClosedChannelException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.truncate(4L);
            byte[] bytes = Arrays.copyOf(c.array(), (int)c.size());
            Assertions.assertEquals((Object)"Some", (Object)new String(bytes, StandardCharsets.UTF_8));
        }
    }

    @Test
    void testShouldWriteDataProperly() throws IOException {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            ByteBuffer inData = ByteBuffer.wrap(testData);
            int writeCount = c.write(inData);
            Assertions.assertEquals((int)testData.length, (int)writeCount);
            Assertions.assertEquals((long)testData.length, (long)c.position());
            Assertions.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOf(c.array(), (int)c.position()));
        }
    }

    @Test
    void testShouldWriteDataProperlyAfterPositionSet() throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])((byte[])testData.clone()));){
            ByteBuffer inData = ByteBuffer.wrap(testData);
            ByteBuffer expectedData = ByteBuffer.allocate(testData.length + 5).put(testData, 0, 5).put(testData);
            c.position(5L);
            int writeCount = c.write(inData);
            Assertions.assertEquals((int)testData.length, (int)writeCount);
            Assertions.assertArrayEquals((byte[])expectedData.array(), (byte[])Arrays.copyOf(c.array(), (int)c.size()));
            Assertions.assertEquals((long)(testData.length + 5), (long)c.position());
        }
    }

    @Test
    void testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, () -> ByteArraySeekableByteChannelCompressTest.lambda$testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel$4((SeekableByteChannel)c));
        }
    }

    @Test
    void testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArraySeekableByteChannelCompressTest.lambda$testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize$5((SeekableByteChannel)c));
        }
    }

    @Test
    void testThrowsIOExceptionWhenPositionIsSetToANegativeValue() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> ByteArraySeekableByteChannelCompressTest.lambda$testThrowsIOExceptionWhenPositionIsSetToANegativeValue$6((SeekableByteChannel)c));
        }
    }

    @Test
    void testTruncateDoesntChangeSmallPosition() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.position(1L);
            c.truncate(testData.length - 1);
            Assertions.assertEquals((long)(testData.length - 1), (long)c.size());
            Assertions.assertEquals((long)1L, (long)c.position());
        }
    }

    @Test
    void testTruncateMovesPositionWhenNewSizeIsBiggerThanSizeAndPositionIsEvenBigger() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.position(2 * testData.length);
            c.truncate(testData.length + 1);
            Assertions.assertEquals((long)testData.length, (long)c.size());
            Assertions.assertEquals((long)(testData.length + 1), (long)c.position());
        }
    }

    @Test
    void testTruncateMovesPositionWhenNotResizingButPositionBiggerThanSize() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.position(2 * testData.length);
            c.truncate(testData.length);
            Assertions.assertEquals((long)testData.length, (long)c.size());
            Assertions.assertEquals((long)testData.length, (long)c.position());
        }
    }

    @Test
    void testTruncateMovesPositionWhenShrinkingBeyondPosition() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            c.position(4L);
            c.truncate(3L);
            Assertions.assertEquals((long)3L, (long)c.size());
            Assertions.assertEquals((long)3L, (long)c.position());
        }
    }

    @Test
    void testTruncateToBiggerSizeDoesntChangeAnything() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            Assertions.assertEquals((long)testData.length, (long)c.size());
            c.truncate(testData.length + 1);
            Assertions.assertEquals((long)testData.length, (long)c.size());
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length);
            Assertions.assertEquals((int)testData.length, (int)c.read(readBuffer));
            Assertions.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOf(readBuffer.array(), testData.length));
        }
    }

    @Test
    void testTruncateToCurrentSizeDoesntChangeAnything() throws Exception {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])testData);){
            Assertions.assertEquals((long)testData.length, (long)c.size());
            c.truncate(testData.length);
            Assertions.assertEquals((long)testData.length, (long)c.size());
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length);
            Assertions.assertEquals((int)testData.length, (int)c.read(readBuffer));
            Assertions.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOf(readBuffer.array(), testData.length));
        }
    }

    @Test
    public void throwsClosedChannelExceptionWhenPositionIsReadOnClosedChannel() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, ((SeekableByteChannel)c)::position);
        }
    }

    @Test
    public void throwsClosedChannelExceptionWhenSizeIsReadOnClosedChannel() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, ((SeekableByteChannel)c)::size);
        }
    }

    @Test
    public void throwsClosedChannelExceptionWhenTruncateIsCalledOnClosedChannel() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, () -> ByteArraySeekableByteChannelCompressTest.lambda$throwsClosedChannelExceptionWhenTruncateIsCalledOnClosedChannel$7((SeekableByteChannel)c));
        }
    }

    public void writingToAPositionAfterEndGrowsChannel() throws Exception {
        try (ByteArraySeekableByteChannel c = new ByteArraySeekableByteChannel();){
            c.position(2L);
            Assertions.assertEquals((long)2L, (long)c.position());
            ByteBuffer inData = ByteBuffer.wrap(testData);
            Assertions.assertEquals((int)testData.length, (int)c.write(inData));
            Assertions.assertEquals((long)(testData.length + 2), (long)c.size());
            c.position(2L);
            ByteBuffer readBuffer = ByteBuffer.allocate(testData.length);
            c.read(readBuffer);
            Assertions.assertArrayEquals((byte[])testData, (byte[])Arrays.copyOf(readBuffer.array(), testData.length));
        }
    }

    private static /* synthetic */ void lambda$throwsClosedChannelExceptionWhenTruncateIsCalledOnClosedChannel$7(SeekableByteChannel c) throws Throwable {
        c.truncate(0L);
    }

    private static /* synthetic */ void lambda$testThrowsIOExceptionWhenPositionIsSetToANegativeValue$6(SeekableByteChannel c) throws Throwable {
        c.position(-1L);
    }

    private static /* synthetic */ void lambda$testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize$5(SeekableByteChannel c) throws Throwable {
        c.truncate(-1L);
    }

    private static /* synthetic */ void lambda$testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel$4(SeekableByteChannel c) throws Throwable {
        c.position(0L);
    }
}

