/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ode.nonstiff.AdamsNordsieckTransformer;
import org.junit.Assert;
import org.junit.Test;

public class AdamsNordsieckTransformerTest {
    @Test
    public void testPolynomialExtraDerivative() {
        this.checkNordsieckStart(new PolynomialFunction(new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0}), 5, 0.0, 0.125, 3.2E-16);
    }

    @Test
    public void testPolynomialRegular() {
        this.checkNordsieckStart(new PolynomialFunction(new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0}), 4, 0.0, 0.125, 3.1E-16);
    }

    @Test
    public void testPolynomialMissingLastDerivative() {
        this.checkNordsieckStart(new PolynomialFunction(new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0}), 3, 0.0, 0.125, 1.6E-4);
    }

    @Test
    public void testTransformExact() {
        this.checkTransform(new PolynomialFunction(new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0}), 5, 2.567E-15);
    }

    @Test
    public void testTransformInexact() {
        this.checkTransform(new PolynomialFunction(new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0}), 4, 5.658E-4);
    }

    private void checkNordsieckStart(PolynomialFunction polynomial, int nbSteps, double t0, double h, double epsilon) {
        AdamsNordsieckTransformer transformer = AdamsNordsieckTransformer.getInstance((int)nbSteps);
        PolynomialFunction derivative = polynomial.polynomialDerivative();
        Array2DRowRealMatrix nordsieck = this.start(transformer, nbSteps, t0, h, (UnivariateFunction)polynomial, (UnivariateFunction)derivative);
        Assert.assertEquals((long)(nbSteps - 1), (long)nordsieck.getRowDimension());
        double coeff = h;
        for (int i = 0; i < nordsieck.getRowDimension(); ++i) {
            derivative = derivative.polynomialDerivative();
            Assert.assertEquals((double)(derivative.value(t0) * (coeff *= h / (double)(i + 2))), (double)nordsieck.getEntry(i, 0), (double)epsilon);
        }
    }

    private void checkTransform(PolynomialFunction polynomial, int nbSteps, double expectedError) {
        AdamsNordsieckTransformer transformer = AdamsNordsieckTransformer.getInstance((int)nbSteps);
        PolynomialFunction derivative = polynomial.polynomialDerivative();
        double t0 = 0.0;
        double h = 0.125;
        Array2DRowRealMatrix n0 = this.start(transformer, nbSteps, 0.0, 0.125, (UnivariateFunction)polynomial, (UnivariateFunction)derivative);
        Array2DRowRealMatrix n1 = transformer.updateHighOrderDerivativesPhase1(n0);
        transformer.updateHighOrderDerivativesPhase2(new double[]{0.125 * derivative.value(0.0)}, new double[]{0.125 * derivative.value(0.125)}, n1);
        Array2DRowRealMatrix n2 = this.start(transformer, nbSteps, 0.125, 0.125, (UnivariateFunction)polynomial, (UnivariateFunction)derivative);
        Assert.assertEquals((double)expectedError, (double)n2.subtract(n1).getNorm(), (double)(expectedError * 0.001));
    }

    private Array2DRowRealMatrix start(AdamsNordsieckTransformer transformer, int nbSteps, double t0, double h, UnivariateFunction f0, UnivariateFunction f1) {
        int nbStartPoints = (nbSteps + 3) / 2;
        double[] t = new double[nbStartPoints];
        double[][] y = new double[nbStartPoints][1];
        double[][] yDot = new double[nbStartPoints][1];
        for (int i = 0; i < nbStartPoints; ++i) {
            t[i] = t0 + (double)i * h;
            y[i][0] = f0.value(t[i]);
            yDot[i][0] = f1.value(t[i]);
        }
        return transformer.initializeHighOrderDerivatives(h, t, y, yDot);
    }
}

