/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PoolTest {
    private static final CharSequence COMMONS_POOL_EVICTIONS_TIMER_THREAD_NAME = "commons-pool-EvictionTimer";
    private static final long EVICTION_PERIOD_IN_MILLIS = 100L;

    @Test
    public void testPool() throws Exception {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setTestWhileIdle(true);
        PooledFooFactory pooledFooFactory = new PooledFooFactory();
        Thread[] threadArray = null;
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pooledFooFactory, poolConfig);){
            pool.setTimeBetweenEvictionRunsMillis(100L);
            pool.addObject();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        catch (Throwable object) {
            threadArray = object;
            throw object;
        }
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null) continue;
            String name = thread.getName();
            Assert.assertFalse((String)name, (boolean)name.contains(COMMONS_POOL_EVICTIONS_TIMER_THREAD_NAME));
        }
    }

    private static class PooledFooFactory
    implements PooledObjectFactory<Foo> {
        private static final long VALIDATION_WAIT_IN_MILLIS = 1000L;

        private PooledFooFactory() {
        }

        public PooledObject<Foo> makeObject() throws Exception {
            return new DefaultPooledObject((Object)new Foo());
        }

        public void destroyObject(PooledObject<Foo> pooledObject) throws Exception {
        }

        public boolean validateObject(PooledObject<Foo> pooledObject) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            return false;
        }

        public void activateObject(PooledObject<Foo> pooledObject) throws Exception {
        }

        public void passivateObject(PooledObject<Foo> pooledObject) throws Exception {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

