/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class HdfsFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HdfsFileSystemConfigBuilder BUILDER = new HdfsFileSystemConfigBuilder();
    private static final String KEY_CONFIG_NAMES = "configNames";
    private static final String KEY_CONFIG_PATHS = "configPaths";
    private static final String KEY_CONFIG_URLS = "configURLs";
    private static final String KEY_CONFIG_STREAM = "configStream";
    private static final String KEY_CONFIG_CONF = "configConf";

    public static HdfsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private HdfsFileSystemConfigBuilder() {
        super("hdfs.");
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return HdfsFileSystem.class;
    }

    public Configuration getConfigConfiguration(FileSystemOptions opts) {
        return (Configuration)this.getParam(opts, KEY_CONFIG_CONF);
    }

    public InputStream getConfigInputStream(FileSystemOptions opts) {
        return (InputStream)this.getParam(opts, KEY_CONFIG_STREAM);
    }

    public String[] getConfigNames(FileSystemOptions opts) {
        String names = this.getString(opts, KEY_CONFIG_NAMES);
        return StringUtils.isEmpty((CharSequence)names) ? null : names.split(",");
    }

    public Path[] getConfigPaths(FileSystemOptions opts) {
        String pathNames = this.getString(opts, KEY_CONFIG_PATHS);
        if (StringUtils.isEmpty((CharSequence)pathNames)) {
            return null;
        }
        return (Path[])Stream.of(pathNames.split(",")).map(Path::new).toArray(Path[]::new);
    }

    public URL[] getConfigURLs(FileSystemOptions opts) {
        String urlNames = this.getString(opts, KEY_CONFIG_URLS);
        if (StringUtils.isEmpty((CharSequence)urlNames)) {
            return null;
        }
        String[] urls = urlNames.split(",");
        URL[] realURLs = new URL[urls.length];
        Arrays.setAll(realURLs, i -> {
            try {
                return new URL(urls[i]);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(urls[i], e);
            }
        });
        return realURLs;
    }

    public void setConfigConfiguration(FileSystemOptions opts, Configuration configuration) {
        this.setParam(opts, KEY_CONFIG_CONF, configuration);
    }

    public void setConfigInputStream(FileSystemOptions opts, InputStream inputStream) {
        this.setParam(opts, KEY_CONFIG_STREAM, inputStream);
    }

    public void setConfigName(FileSystemOptions opts, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.setParam(opts, KEY_CONFIG_NAMES, null);
        } else {
            String previousNames = this.getString(opts, KEY_CONFIG_NAMES);
            if (previousNames == null || previousNames.isEmpty()) {
                this.setParam(opts, KEY_CONFIG_NAMES, name);
            } else {
                this.setParam(opts, KEY_CONFIG_NAMES, previousNames + "," + name);
            }
        }
    }

    public void setConfigPath(FileSystemOptions opts, Path path) {
        if (path == null) {
            this.setParam(opts, KEY_CONFIG_PATHS, null);
        } else {
            String previousPathNames = this.getString(opts, KEY_CONFIG_PATHS);
            if (StringUtils.isEmpty((CharSequence)previousPathNames)) {
                this.setParam(opts, KEY_CONFIG_PATHS, path.toString());
            } else {
                this.setParam(opts, KEY_CONFIG_PATHS, previousPathNames + "," + path);
            }
        }
    }

    public void setConfigURL(FileSystemOptions opts, URL url) {
        if (url == null) {
            this.setParam(opts, KEY_CONFIG_URLS, null);
        } else {
            String previousURLNames = this.getString(opts, KEY_CONFIG_URLS);
            if (StringUtils.isEmpty((CharSequence)previousURLNames)) {
                this.setParam(opts, KEY_CONFIG_URLS, url.toString());
            } else {
                this.setParam(opts, KEY_CONFIG_URLS, previousURLNames + "," + url);
            }
        }
    }
}

