/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.IPv6LocalConnectionTests;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.AbstractSftpProviderTestCase;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.junit.Test;
import org.mockito.Mockito;

public class SftpProviderIPv6TestCase
extends AbstractSftpProviderTestCase {
    public static junit.framework.Test suite() throws Exception {
        return new AbstractSftpProviderTestCase.SftpProviderTestSuite(new SftpProviderIPv6TestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                this.addTests(SftpProviderIPv6TestCase.class);
                if (AbstractSftpProviderTestCase.getSystemTestUriOverride() == null) {
                    this.addTests(IPv6LocalConnectionTests.class);
                }
            }
        };
    }

    @Override
    protected boolean isExecChannelClosed() {
        return false;
    }

    @Test
    public void testResolveIPv6Url() throws Exception {
        try {
            this.getManager().removeProvider("sftp");
            this.getManager().addProvider("sftp", (FileProvider)new MockedClientSftpFileProvider());
            String ipv6Url = "sftp://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt";
            FileObject fileObject = this.getManager().resolveFile("sftp://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", new FileSystemOptions());
            SftpProviderIPv6TestCase.assertEquals((String)"sftp://user:pass@[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getFileSystem().getRootURI());
            SftpProviderIPv6TestCase.assertEquals((String)"sftp://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", (String)fileObject.getName().getURI());
        }
        finally {
            this.getManager().removeProvider("sftp");
            this.getManager().addProvider("sftp", (FileProvider)new SftpFileProvider());
        }
    }

    private static class MockedClientSftpFileProvider
    extends SftpFileProvider {
        private MockedClientSftpFileProvider() {
        }

        protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) {
            GenericFileName rootName = (GenericFileName)name;
            Session sessionMock = (Session)Mockito.mock(Session.class);
            ChannelExec channelExecMock = (ChannelExec)Mockito.mock(ChannelExec.class);
            Mockito.when((Object)sessionMock.isConnected()).thenReturn((Object)true);
            try {
                Mockito.when((Object)sessionMock.openChannel(Mockito.anyString())).thenReturn((Object)channelExecMock);
            }
            catch (JSchException e) {
                throw new AssertionError("Should never happen", e);
            }
            Mockito.when((Object)channelExecMock.isClosed()).thenReturn((Object)true);
            try {
                Mockito.when((Object)channelExecMock.getInputStream()).thenReturn((Object)new NullInputStream());
            }
            catch (IOException e) {
                throw new AssertionError("Should never happen", e);
            }
            return new SftpFileSystem(rootName, sessionMock, fileSystemOptions);
        }
    }
}

