/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import java.util.Objects;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.SessionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.SessionFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class SessionView
extends ActiveMQAbstractView<ServerSession> {
    private static final String defaultSortField = SessionField.ID.getName();

    public SessionView() {
        this.predicate = new SessionFilterPredicate();
    }

    @Override
    public Class getClassT() {
        return ServerSession.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerSession session) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(SessionField.ID.getName(), this.toString(session.getName())).add(SessionField.USER.getName(), this.toString(session.getUsername())).add(SessionField.VALIDATED_USER.getName(), this.toString(session.getValidatedUser())).add(SessionField.CREATION_TIME.getName(), new Date(session.getCreationTime()).toString()).add(SessionField.CONSUMER_COUNT.getName(), session.getConsumerCount()).add(SessionField.PRODUCER_COUNT.getName(), session.getProducerCount()).add(SessionField.CONNECTION_ID.getName(), session.getConnectionID().toString()).add(SessionField.CLIENT_ID.getName(), Objects.requireNonNullElse(session.getRemotingConnection().getClientID(), ""));
        return obj;
    }

    @Override
    public Object getField(ServerSession session, String fieldName) {
        SessionField field = SessionField.valueOfName(fieldName);
        return switch (field) {
            case SessionField.ID -> session.getName();
            case SessionField.USER -> session.getUsername();
            case SessionField.VALIDATED_USER -> session.getValidatedUser();
            case SessionField.CREATION_TIME -> new Date(session.getCreationTime());
            case SessionField.CONSUMER_COUNT -> session.getConsumerCount();
            case SessionField.PRODUCER_COUNT -> session.getProducerCount();
            case SessionField.CONNECTION_ID -> session.getConnectionID();
            case SessionField.CLIENT_ID -> session.getRemotingConnection().getClientID();
            default -> throw new IllegalArgumentException("Unsupported field, " + fieldName);
        };
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortField;
    }
}

