/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.OAuthInvoker;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.IdTokenReader;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;

public class OidcInvoker
extends OAuthInvoker {
    private IdTokenReader idTokenReader;

    protected void validateRefreshedToken(ClientTokenContext tokenContext, ClientAccessToken refreshedToken) {
        if (refreshedToken.getParameters().containsKey("id_token")) {
            IdToken newIdToken = this.idTokenReader.getIdToken(refreshedToken, this.getConsumer());
            OidcClientTokenContextImpl oidcContext = (OidcClientTokenContextImpl)tokenContext;
            IdToken currentIdToken = oidcContext.getIdToken();
            if (!newIdToken.getIssuer().equals(currentIdToken.getIssuer())) {
                throw new OAuthServiceException("Invalid id token issuer");
            }
            if (!newIdToken.getSubject().equals(currentIdToken.getSubject())) {
                throw new OAuthServiceException("Invalid id token subject");
            }
            if (!newIdToken.getAudiences().containsAll(currentIdToken.getAudiences())) {
                throw new OAuthServiceException("Invalid id token audience(s)");
            }
            Long newAuthTime = newIdToken.getAuthenticationTime();
            if (newAuthTime != null && !newAuthTime.equals(currentIdToken.getAuthenticationTime())) {
                throw new OAuthServiceException("Invalid id token auth_time");
            }
            String newAzp = newIdToken.getAuthorizedParty();
            String origAzp = currentIdToken.getAuthorizedParty();
            if (newAzp != null && origAzp == null || newAzp == null && origAzp != null || newAzp != null && origAzp != null && !newAzp.equals(origAzp)) {
                throw new OAuthServiceException("Invalid id token authorized party");
            }
            Long newIssuedTime = newIdToken.getIssuedAt();
            Long origIssuedTime = currentIdToken.getIssuedAt();
            if (newIssuedTime < origIssuedTime) {
                throw new OAuthServiceException("Invalid id token issued time");
            }
            oidcContext.setIdToken(newIdToken);
        }
    }

    public void setIdTokenReader(IdTokenReader idTokenReader) {
        this.idTokenReader = idTokenReader;
    }
}

