/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GMonthDayValue
extends GDateValue {
    private static final Pattern regex = Pattern.compile("--([0-9][0-9]-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthDayValue(GDateValue.MutableGDateValue m) {
        super(m);
    }

    public static ConversionResult makeGMonthDayValue(UnicodeString value) {
        UnicodeString trimmed = Whitespace.trim(value);
        Matcher m = regex.matcher(trimmed.toString());
        if (!m.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gMonthDay");
        }
        GDateValue.MutableGDateValue g = new GDateValue.MutableGDateValue();
        String base = m.group(1);
        String tz = m.group(2);
        String date = "2000-" + base + (tz == null ? "" : tz);
        g.typeLabel = BuiltInAtomicType.G_MONTH_DAY;
        GMonthDayValue.setLexicalValue(g, BMPString.of(date), true);
        return g.error == null ? new GMonthDayValue(g) : g.error;
    }

    public GMonthDayValue(byte month, byte day, int tz) {
        this(month, day, tz, BuiltInAtomicType.G_MONTH_DAY);
    }

    public GMonthDayValue(byte month, byte day, int tz, AtomicType type) {
        this(new GDateValue.MutableGDateValue(2000, month, day, false, tz, type));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GDateValue.MutableGDateValue m = this.makeMutableCopy();
        m.typeLabel = typeLabel;
        return new GMonthDayValue(m);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH_DAY;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        sb.appendLatin("--");
        GMonthDayValue.appendTwoDigits(sb, this.month);
        sb.append('-');
        GMonthDayValue.appendTwoDigits(sb, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb.toUnicodeString();
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        throw new XPathException("Cannot add a duration to an xs:gMonthDay", "XPTY0004").asTypeError();
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = this.toDateTime().adjustTimezone(tz);
        return new GMonthDayValue(dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes());
    }
}

