/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp;

import java.io.IOException;
import org.apache.directory.server.ntp.protocol.NtpProtocolCodecFactory;
import org.apache.directory.server.ntp.protocol.NtpProtocolHandler;
import org.apache.directory.server.protocol.shared.AbstractProtocolService;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpServer
extends AbstractProtocolService {
    private static final Logger LOG = LoggerFactory.getLogger(NtpServer.class);
    private static final int IP_PORT_DEFAULT = 123;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ntp";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS NTP Service";

    public NtpServer() {
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
    }

    @Override
    public void start() throws IOException {
        NtpProtocolHandler ntpProtocolHandler = new NtpProtocolHandler();
        DefaultIoFilterChainBuilder ntpChain = new DefaultIoFilterChainBuilder();
        ntpChain.addLast("codec", new ProtocolCodecFilter(NtpProtocolCodecFactory.getInstance()));
        if (this.transports == null || this.transports.isEmpty()) {
            UdpTransport transport = new UdpTransport(123);
            this.setTransports(transport);
            DatagramAcceptor acceptor = transport.getAcceptor();
            acceptor.setHandler(ntpProtocolHandler);
            acceptor.getSessionConfig().setReuseAddress(true);
            acceptor.setFilterChainBuilder(ntpChain);
            acceptor.bind();
        } else {
            for (Transport transport : this.transports) {
                IoAcceptor acceptor = transport.getAcceptor();
                acceptor.setHandler(ntpProtocolHandler);
                if (transport instanceof UdpTransport) {
                    ((DatagramSessionConfig)acceptor.getSessionConfig()).setReuseAddress(true);
                } else {
                    acceptor.setCloseOnDeactivation(false);
                    ((SocketAcceptor)acceptor).setReuseAddress(true);
                    ((SocketAcceptor)acceptor).getSessionConfig().setTcpNoDelay(true);
                }
                acceptor.setFilterChainBuilder(ntpChain);
                acceptor.bind();
            }
        }
        LOG.info("NTP server started.");
    }

    @Override
    public void stop() {
        for (Transport transport : this.getTransports()) {
            IoAcceptor acceptor = transport.getAcceptor();
            if (acceptor == null) continue;
            acceptor.dispose();
        }
        LOG.info("NTP Server stopped.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NTPServer[").append(this.getServiceName()).append("], listening on :").append('\n');
        if (this.getTransports() != null) {
            for (Transport transport : this.getTransports()) {
                sb.append("    ").append(transport).append('\n');
            }
        }
        return sb.toString();
    }
}

