/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.AbandonableRequest;
import org.apache.directory.api.ldap.model.message.BindStatus;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.SearchRequestContainer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.controls.PagedSearchContext;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSession {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSession.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final AbandonableRequest[] EMPTY_ABANDONABLES = new AbandonableRequest[0];
    private final Lock outstandingLock;
    private final IoSession ioSession;
    private CoreSession coreSession;
    private LdapServer ldapServer;
    private Map<Integer, AbandonableRequest> outstandingRequests;
    private Map<Integer, SearchRequestContainer> searchRequests;
    private BindStatus bindStatus;
    private String currentMechanism;
    private Map<String, Object> saslProperties;
    private Map<Integer, PagedSearchContext> pagedSearchContexts;

    public LdapSession(IoSession ioSession) {
        this.ioSession = ioSession;
        this.outstandingLock = new ReentrantLock();
        this.outstandingRequests = new ConcurrentHashMap<Integer, AbandonableRequest>();
        this.searchRequests = new ConcurrentHashMap<Integer, SearchRequestContainer>();
        this.bindStatus = BindStatus.ANONYMOUS;
        this.saslProperties = new HashMap<String, Object>();
        this.pagedSearchContexts = new ConcurrentHashMap<Integer, PagedSearchContext>();
    }

    public boolean isAuthenticated() {
        return this.coreSession != null && this.bindStatus == BindStatus.AUTHENTICATED;
    }

    public boolean isAnonymous() {
        return this.bindStatus == BindStatus.ANONYMOUS;
    }

    public boolean isAuthPending() {
        return this.bindStatus == BindStatus.SIMPLE_AUTH_PENDING || this.bindStatus == BindStatus.SASL_AUTH_PENDING;
    }

    public boolean isSimpleAuthPending() {
        return this.bindStatus == BindStatus.SIMPLE_AUTH_PENDING;
    }

    public boolean isSaslAuthPending() {
        return this.bindStatus == BindStatus.SASL_AUTH_PENDING;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void setCoreSession(CoreSession coreSession) {
        this.coreSession = coreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonAllOutstandingRequests() {
        try {
            AbandonableRequest[] abandonables;
            this.outstandingLock.lock();
            for (AbandonableRequest abandonable : abandonables = this.outstandingRequests.values().toArray(EMPTY_ABANDONABLES)) {
                this.abandonOutstandingRequest(abandonable.getMessageId());
            }
        }
        finally {
            this.outstandingLock.unlock();
        }
    }

    public AbandonableRequest abandonOutstandingRequest(int messageId) {
        AbandonableRequest request = null;
        try {
            this.outstandingLock.lock();
            request = this.outstandingRequests.remove(messageId);
        }
        finally {
            this.outstandingLock.unlock();
        }
        try {
            this.closeAllPagedSearches();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_172, e.getLocalizedMessage()));
        }
        if (request == null) {
            LOG.warn("AbandonableRequest with messageId {} not found in outstandingRequests.", (Object)messageId);
            return null;
        }
        if (request.isAbandoned()) {
            LOG.info("AbandonableRequest with messageId {} has already been abandoned", (Object)messageId);
            return request;
        }
        request.abandon();
        if (IS_DEBUG) {
            LOG.debug("AbandonRequest on AbandonableRequest wth messageId {} was successful.", (Object)messageId);
        }
        return request;
    }

    public void registerOutstandingRequest(AbandonableRequest request) {
        try {
            this.outstandingLock.lock();
            this.outstandingRequests.put(request.getMessageId(), request);
        }
        finally {
            this.outstandingLock.unlock();
        }
    }

    public void unregisterOutstandingRequest(AbandonableRequest request) {
        try {
            this.outstandingLock.lock();
            this.outstandingRequests.remove(request.getMessageId());
        }
        finally {
            this.outstandingLock.unlock();
        }
    }

    public Map<Integer, AbandonableRequest> getOutstandingRequests() {
        try {
            this.outstandingLock.lock();
            Map<Integer, AbandonableRequest> map = Collections.unmodifiableMap(this.outstandingRequests);
            return map;
        }
        finally {
            this.outstandingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSearchRequest(SearchRequest searchRequest, Cursor<Entry> cursor) {
        try {
            this.outstandingLock.lock();
            SearchRequestContainer searchRequestContainer = new SearchRequestContainer(searchRequest, cursor);
            this.searchRequests.put(searchRequest.getMessageId(), searchRequestContainer);
        }
        finally {
            this.outstandingLock.unlock();
        }
    }

    public void unregisterSearchRequest(SearchRequest searchRequest) {
        this.searchRequests.remove(searchRequest.getMessageId());
    }

    public SearchRequestContainer getSearchRequest(int messageId) {
        return this.searchRequests.get(messageId);
    }

    public BindStatus getBindStatus() {
        return this.bindStatus;
    }

    public void setSimpleAuthPending() {
        this.bindStatus = BindStatus.SIMPLE_AUTH_PENDING;
    }

    public void setSaslAuthPending() {
        this.bindStatus = BindStatus.SASL_AUTH_PENDING;
    }

    public void setAnonymous() {
        this.bindStatus = BindStatus.ANONYMOUS;
    }

    public void setAuthenticated() {
        this.bindStatus = BindStatus.AUTHENTICATED;
    }

    public String getCurrentMechanism() {
        return this.currentMechanism;
    }

    public void putSaslProperty(String property, Object value) {
        this.saslProperties.put(property, value);
    }

    public Object getSaslProperty(String property) {
        return this.saslProperties.get(property);
    }

    public void clearSaslProperties() {
        this.saslProperties.clear();
    }

    public void removeSaslProperty(String property) {
        this.saslProperties.remove(property);
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public void addPagedSearchContext(PagedSearchContext context) {
        Cursor<Entry> cursor;
        PagedSearchContext oldContext = this.pagedSearchContexts.put(context.getCookieValue(), context);
        if (oldContext != null && (cursor = oldContext.getCursor()) != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_172, e.getLocalizedMessage()));
            }
        }
    }

    public PagedSearchContext removePagedSearchContext(int contextId) {
        return this.pagedSearchContexts.remove(contextId);
    }

    public void closeAllPagedSearches() throws IOException {
        for (Map.Entry<Integer, PagedSearchContext> entry : this.pagedSearchContexts.entrySet()) {
            Cursor<Entry> cursor = entry.getValue().getCursor();
            if (cursor == null) continue;
            cursor.close();
        }
    }

    public PagedSearchContext getPagedSearchContext(int contextId) {
        return this.pagedSearchContexts.get(contextId);
    }

    public String toString() {
        if (this.coreSession == null) {
            return "LdapSession : No Ldap session ...";
        }
        StringBuilder sb = new StringBuilder();
        LdapPrincipal principal = this.coreSession.getAuthenticatedPrincipal();
        SocketAddress address = this.coreSession.getClientAddress();
        sb.append("LdapSession : <");
        if (principal != null) {
            sb.append(principal);
            sb.append(",");
        }
        if (address != null) {
            sb.append(address);
        } else {
            sb.append("...");
        }
        sb.append(">");
        return sb.toString();
    }
}

