/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.ConfigDAO;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigP {
    private static final String CLS_NM = ConfigP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    ConfigP() {
    }

    Configuration add(Configuration cfg) throws SecurityException {
        this.validate(cfg.getName(), cfg.getProperties(), false);
        ConfigDAO cfgDao = new ConfigDAO();
        return cfgDao.create(cfg);
    }

    Configuration update(Configuration cfg) throws SecurityException {
        this.validate(cfg.getName(), cfg.getProperties(), true);
        ConfigDAO cfgDao = new ConfigDAO();
        return cfgDao.update(cfg);
    }

    void updateProperty(String name, String key, String value, String newValue) throws SecurityException {
        ConfigDAO cfgDao = new ConfigDAO();
        cfgDao.updateProperty(name, key, value, newValue);
    }

    void delete(String name) throws SecurityException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            String error = "delete detected null config realm name";
            LOG.warn(error);
            throw new ValidationException(108, error);
        }
        ConfigDAO cfgDao = new ConfigDAO();
        cfgDao.remove(name);
    }

    void delete(String name, Properties inProps) throws SecurityException {
        this.validate(name, inProps, false);
        ConfigDAO cfgDao = new ConfigDAO();
        cfgDao.remove(name, inProps);
    }

    Configuration read(String name) throws SecurityException {
        ConfigDAO cfgDao = new ConfigDAO();
        return cfgDao.getConfig(name);
    }

    Configuration readPosixIds(String name) throws SecurityException {
        ConfigDAO cfgDao = new ConfigDAO();
        return cfgDao.getPosixIds(name);
    }

    private void validate(String name, Properties entity, boolean isUpdate) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            String error = "validate detected null config realm name";
            LOG.warn(error);
            throw new ValidationException(108, error);
        }
        if (name.length() > 40) {
            String error = "validate name [" + name + "] invalid length [" + name.length() + "]";
            LOG.warn(error);
            throw new ValidationException(109, error);
        }
        if (!(isUpdate || entity != null && entity.size() != 0)) {
            String error = "validate name [" + name + "] config props null";
            LOG.warn(error);
            throw new ValidationException(110, error);
        }
        VUtil.properties(entity);
    }
}

