/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class DelReviewMgrRestImpl
extends Manageable
implements DelReviewMgr {
    private static final String CLS_NM = DelReviewMgrRestImpl.class.getName();

    @Override
    public AdminRole readRole(AdminRole role) throws SecurityException {
        VUtil.assertNotNull(role, 9007, CLS_NM + ".readRole");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        AdminRole retRole = (AdminRole)response.getEntity();
        return retRole;
    }

    @Override
    public List<AdminRole> findRoles(String searchVal) throws SecurityException {
        VUtil.assertNotNull(searchVal, 9005, CLS_NM + ".findRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setValue(searchVal);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<AdminRole> retRoles = response.getEntities();
        return retRoles;
    }

    @Override
    public List<UserAdminRole> assignedRoles(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".assignedRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "arleAsigned");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserAdminRole> retUserRoles = response.getEntities();
        return retUserRoles;
    }

    @Override
    public List<User> assignedUsers(AdminRole role) throws SecurityException {
        List<User> retUsers;
        VUtil.assertNotNull(role, 9007, CLS_NM + ".assignedUsers");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAsignedAdmin");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() == 0) {
            retUsers = response.getEntities();
            if (retUsers == null) {
                retUsers = new ArrayList<User>();
            }
        } else {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        return retUsers;
    }

    @Override
    public OrgUnit read(OrgUnit entity) throws SecurityException {
        VUtil.assertNotNull(entity, 8001, CLS_NM + ".readOrgUnit");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setEntity(entity);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        OrgUnit retOrg = (OrgUnit)response.getEntity();
        return retOrg;
    }

    @Override
    public List<OrgUnit> search(OrgUnit.Type type, String searchVal) throws SecurityException {
        VUtil.assertNotNull((Object)type, 8002, CLS_NM + ".search");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        OrgUnit inOrg = new OrgUnit(searchVal, type);
        request.setEntity(inOrg);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "orgSearch");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<OrgUnit> retOrgs = response.getEntities();
        return retOrgs;
    }

    @Override
    public List<Permission> rolePermissions(AdminRole role) throws SecurityException {
        return null;
    }

    @Override
    public List<Permission> rolePermissions(AdminRole role, boolean noInheritance) throws SecurityException {
        return null;
    }
}

