/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.filesystem;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class PathEditorInput
implements IPathEditorInput,
ILocationProvider {
    private IPath path;

    public PathEditorInput(IPath path) {
        this.path = path;
    }

    public boolean exists() {
        if (this.path != null) {
            return this.path.toFile().exists();
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.path.toString());
    }

    public String getName() {
        if (this.path != null) {
            return this.path.toFile().getName();
        }
        return "";
    }

    public IPath getPath() {
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public IPath getPath(Object element) {
        if (element instanceof PathEditorInput) {
            return ((PathEditorInput)element).getPath();
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.path != null) {
            return this.path.makeRelative().toOSString();
        }
        return "";
    }

    public int hashCode() {
        if (this.path != null) {
            return this.path.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this.path != null) {
            if (this == o) {
                return true;
            }
            if (o instanceof PathEditorInput) {
                PathEditorInput input = (PathEditorInput)o;
                return this.path.equals((Object)input.path);
            }
        }
        return super.equals(o);
    }
}

