/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class SchemaEditorTypeLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof AttributeTypeWrapper) {
            UsageEnum usage = ((AttributeTypeWrapper)element).getAttributeType().getUsage();
            if (usage == UsageEnum.USER_APPLICATIONS) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_overlay_userApplication.gif"), 3);
            } else if (usage == UsageEnum.DIRECTORY_OPERATION || usage == UsageEnum.DISTRIBUTED_OPERATION || usage == UsageEnum.DSA_OPERATION) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_overlay_operation.gif"), 3);
            }
        } else if (element instanceof ObjectClassWrapper) {
            ObjectClassTypeEnum classType = ((ObjectClassWrapper)element).getObjectClass().getType();
            if (classType == ObjectClassTypeEnum.ABSTRACT) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_abstract.gif"), 3);
            } else if (classType == ObjectClassTypeEnum.STRUCTURAL) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_structural.gif"), 3);
            } else if (classType == ObjectClassTypeEnum.AUXILIARY) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_auxiliary.gif"), 3);
            }
        } else if (element instanceof AttributeType) {
            UsageEnum usage = ((AttributeType)element).getUsage();
            if (usage == UsageEnum.USER_APPLICATIONS) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_overlay_userApplication.gif"), 3);
            } else if (usage == UsageEnum.DIRECTORY_OPERATION || usage == UsageEnum.DISTRIBUTED_OPERATION || usage == UsageEnum.DSA_OPERATION) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_overlay_operation.gif"), 3);
            }
        } else if (element instanceof ObjectClass) {
            ObjectClassTypeEnum classType = ((ObjectClass)element).getType();
            if (classType == ObjectClassTypeEnum.ABSTRACT) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_abstract.gif"), 3);
            } else if (classType == ObjectClassTypeEnum.STRUCTURAL) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_structural.gif"), 3);
            } else if (classType == ObjectClassTypeEnum.AUXILIARY) {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/object_class_overlay_auxiliary.gif"), 3);
            }
        }
    }
}

