/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboComparator;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboInput;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ATESuperiorComboContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ATESuperiorComboInput) {
            ATESuperiorComboInput input = (ATESuperiorComboInput)inputElement;
            if (input.getChildren().isEmpty()) {
                AttributeType editorAT = input.getAttributeType();
                input.addChild(new NonExistingAttributeType("(None)"));
                List<AttributeType> ats = this.schemaHandler.getAttributeTypes();
                for (AttributeType at : ats) {
                    if (this.isSubType(at, editorAT)) continue;
                    input.addChild(at);
                }
            }
            List<Object> children = input.getChildren();
            Collections.sort(children, new ATESuperiorComboComparator());
            return children.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isSubType(AttributeType at1, AttributeType at2) {
        if (at1.equals((Object)at2)) {
            return true;
        }
        String sup = at1.getSuperiorOid();
        if (sup == null) {
            return false;
        }
        AttributeType supAT = this.schemaHandler.getAttributeType(sup);
        if (supAT == null) {
            return false;
        }
        return this.isSubType(supAT, at2);
    }
}

