/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SchemaViewLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public String getText(Object element) {
        List<TreeNode> children;
        List names;
        String label = "";
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        int labelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        boolean schemaLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_LABEL_DISPLAY);
        if (element instanceof SchemaWrapper) {
            SchemaWrapper sw = (SchemaWrapper)element;
            return sw.getSchema().getSchemaName();
        }
        if (element instanceof AttributeTypeWrapper) {
            AttributeType at = ((AttributeTypeWrapper)element).getAttributeType();
            label = labelValue == 0 ? ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SchemaViewLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SchemaViewLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SchemaViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = String.valueOf(label.substring(0, abbreviateMaxLength)) + "...";
            }
        } else if (element instanceof ObjectClassWrapper) {
            ObjectClass oc = ((ObjectClassWrapper)element).getObjectClass();
            label = labelValue == 0 ? ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SchemaViewLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("SchemaViewLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("SchemaViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = String.valueOf(label.substring(0, abbreviateMaxLength)) + "...";
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            if (presentation == 0) {
                return String.valueOf(folder.getName()) + " (" + folder.getChildren().size() + ")";
            }
            if (presentation == 1) {
                return folder.getName();
            }
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (element instanceof AttributeTypeWrapper) {
                AttributeType at = ((AttributeTypeWrapper)element).getAttributeType();
                if (secondaryLabelValue == 0) {
                    List names2 = at.getNames();
                    secondaryLabel = names2 != null && names2.size() > 0 ? (String)names2.get(0) : Messages.getString("SchemaViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names3 = at.getNames();
                    secondaryLabel = names3 != null && names3.size() > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("SchemaViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (element instanceof ObjectClassWrapper) {
                ObjectClass oc = ((ObjectClassWrapper)element).getObjectClass();
                if (secondaryLabelValue == 0) {
                    List names4 = oc.getNames();
                    secondaryLabel = names4 != null && names4.size() > 0 ? (String)names4.get(0) : Messages.getString("SchemaViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names5 = oc.getNames();
                    secondaryLabel = names5 != null && names5.size() > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("SchemaViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = String.valueOf(secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength)) + "...";
            }
            label = String.valueOf(label) + "  [" + secondaryLabel + "]";
        }
        if (presentation == 1 && (element instanceof AttributeTypeWrapper || element instanceof ObjectClassWrapper) && (children = ((TreeNode)element).getChildren()) != null && children.size() > 0) {
            label = String.valueOf(label) + "  (" + children.size() + ")";
        }
        if (schemaLabelDisplay) {
            if (element instanceof AttributeTypeWrapper) {
                label = String.valueOf(label) + "  [" + ((AttributeTypeWrapper)element).getAttributeType().getSchemaName() + "]";
            } else if (element instanceof ObjectClassWrapper) {
                label = String.valueOf(label) + "  [" + ((ObjectClassWrapper)element).getObjectClass().getSchemaName() + "]";
            }
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof SchemaWrapper) {
            return Activator.getDefault().getImage("resources/icons/schema.gif");
        }
        if (element instanceof AttributeTypeWrapper) {
            return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
        }
        if (element instanceof ObjectClassWrapper) {
            return Activator.getDefault().getImage("resources/icons/object_class.gif");
        }
        if (element instanceof Folder) {
            Folder folder = (Folder)element;
            switch (folder.getType()) {
                case ATTRIBUTE_TYPE: {
                    return Activator.getDefault().getImage("resources/icons/folder_at.gif");
                }
                case OBJECT_CLASS: {
                    return Activator.getDefault().getImage("resources/icons/folder_oc.gif");
                }
                case NONE: {
                    return Activator.getDefault().getImage("resources/icons/folder.gif");
                }
            }
        }
        return null;
    }
}

