/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgressAdapter;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImportException;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImporter;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.view.wizards.ImportSchemasFromXmlWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportSchemasFromXmlWizard
extends Wizard
implements IImportWizard {
    private SchemaHandler schemaHandler;
    private SchemaChecker schemaChecker;
    private ImportSchemasFromXmlWizardPage page;

    public void addPages() {
        this.page = new ImportSchemasFromXmlWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final File[] selectedSchemasFiles = this.page.getSelectedSchemaFiles();
        this.schemaChecker.disableModificationsListening();
        StudioConnectionRunnableWithProgressAdapter runnable = new StudioConnectionRunnableWithProgressAdapter(){

            public void run(StudioProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("ImportSchemasFromXmlWizard.ImportingSchemas"), selectedSchemasFiles.length);
                File[] fileArray = selectedSchemasFiles;
                int n = selectedSchemasFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File schemaFile = fileArray[n2];
                    monitor.subTask(schemaFile.getName());
                    try {
                        XMLSchemaFileImporter.SchemaFileType schemaFileType = XMLSchemaFileImporter.getSchemaFileType(new FileInputStream(schemaFile), schemaFile.getAbsolutePath());
                        switch (schemaFileType) {
                            case SINGLE: {
                                Schema importedSchema = XMLSchemaFileImporter.getSchema(new FileInputStream(schemaFile), schemaFile.getAbsolutePath());
                                importedSchema.setProject(Activator.getDefault().getProjectsHandler().getOpenProject());
                                ImportSchemasFromXmlWizard.this.schemaHandler.addSchema(importedSchema);
                                break;
                            }
                            case MULTIPLE: {
                                Schema[] schemas;
                                Schema[] schemaArray = schemas = XMLSchemaFileImporter.getSchemas(new FileInputStream(schemaFile), schemaFile.getAbsolutePath());
                                int n3 = schemas.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Schema schema = schemaArray[n4];
                                    schema.setProject(Activator.getDefault().getProjectsHandler().getOpenProject());
                                    ImportSchemasFromXmlWizard.this.schemaHandler.addSchema(schema);
                                    ++n4;
                                }
                                break block1;
                            }
                        }
                    }
                    catch (XMLSchemaFileImportException e) {
                        this.reportError(e, schemaFile, monitor);
                    }
                    catch (FileNotFoundException e) {
                        this.reportError(e, schemaFile, monitor);
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
                ImportSchemasFromXmlWizard.this.schemaChecker.enableModificationsListening();
            }

            private void reportError(Exception e, File schemaFile, StudioProgressMonitor monitor) {
                String message = NLS.bind((String)Messages.getString("ImportSchemasFromXmlWizard.ErrorImportingSchema"), (Object)schemaFile.getName());
                monitor.reportError(message, e);
            }

            public String getName() {
                return Messages.getString("ImportSchemasFromXmlWizard.ImportingSchemas");
            }
        };
        RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
        this.schemaChecker.enableModificationsListening();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaChecker = Activator.getDefault().getSchemaChecker();
    }
}

