/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;

public class SearchParameter
implements Serializable {
    private static final long serialVersionUID = 2447490121520960805L;
    private String name = null;
    private Dn searchBase = null;
    private String filter = "(objectClass=*)";
    private String[] returningAttributes = ISearch.NO_ATTRIBUTES;
    private SearchScope scope = SearchScope.ONELEVEL;
    private int timeLimit = 0;
    private int countLimit = 0;
    private Connection.AliasDereferencingMethod aliasesDereferencingMethod = Connection.AliasDereferencingMethod.ALWAYS;
    private Connection.ReferralHandlingMethod referralsHandlingMethod = Connection.ReferralHandlingMethod.FOLLOW;
    private List<Control> controls = new ArrayList<Control>();
    private List<Control> responseControls = new ArrayList<Control>();
    protected boolean pagedSearchScrollModeFlag = true;
    private boolean initHasChildrenFlag = false;

    public int getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(int countLimit) {
        this.countLimit = countLimit;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (filter == null || "".equals(filter)) {
            filter = "(objectClass=*)";
        }
        this.filter = filter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getReturningAttributes() {
        return this.returningAttributes;
    }

    public void setReturningAttributes(String[] returningAttributes) {
        if (returningAttributes == null) {
            returningAttributes = new String[]{"*"};
        }
        this.returningAttributes = returningAttributes;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public Connection.AliasDereferencingMethod getAliasesDereferencingMethod() {
        return this.aliasesDereferencingMethod;
    }

    public void setAliasesDereferencingMethod(Connection.AliasDereferencingMethod aliasesDereferencingMethod) {
        this.aliasesDereferencingMethod = aliasesDereferencingMethod;
    }

    public Connection.ReferralHandlingMethod getReferralsHandlingMethod() {
        return this.referralsHandlingMethod;
    }

    public void setReferralsHandlingMethod(Connection.ReferralHandlingMethod referralsHandlingMethod) {
        this.referralsHandlingMethod = referralsHandlingMethod;
    }

    public Dn getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(Dn searchBase) {
        assert (searchBase != null);
        this.searchBase = searchBase;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Object clone() {
        SearchParameter clone = new SearchParameter();
        clone.setName(this.getName());
        clone.setSearchBase(this.getSearchBase());
        clone.setFilter(this.getFilter());
        clone.setReturningAttributes(this.getReturningAttributes());
        clone.setScope(this.getScope());
        clone.setTimeLimit(this.getTimeLimit());
        clone.setCountLimit(this.getCountLimit());
        clone.setAliasesDereferencingMethod(this.getAliasesDereferencingMethod());
        clone.setReferralsHandlingMethod(this.getReferralsHandlingMethod());
        clone.setInitHasChildrenFlag(this.isInitHasChildrenFlag());
        clone.getControls().addAll(this.getControls());
        clone.getResponseControls().addAll(this.getResponseControls());
        return clone;
    }

    public boolean isInitHasChildrenFlag() {
        return this.initHasChildrenFlag;
    }

    public void setInitHasChildrenFlag(boolean initHasChildrenFlag) {
        this.initHasChildrenFlag = initHasChildrenFlag;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public List<Control> getResponseControls() {
        return this.responseControls;
    }

    public boolean isPagedSearchScrollMode() {
        return this.pagedSearchScrollModeFlag;
    }

    public void setPagedSearchScrollMode(boolean pagedSearchScrollModeFlag) {
        this.pagedSearchScrollModeFlag = pagedSearchScrollModeFlag;
    }
}

