/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapFilterExtensibleComponent
extends LdapFilterComponent {
    private LdapFilterToken attributeToken;
    private LdapFilterToken dnAttrColonToken;
    private LdapFilterToken dnAttrToken;
    private LdapFilterToken matchingRuleColonToken;
    private LdapFilterToken matchingRuleToken;
    private LdapFilterToken equalsColonToken;
    private LdapFilterToken equalsToken;
    private LdapFilterToken valueToken;

    public LdapFilterExtensibleComponent(LdapFilter parent) {
        super(parent);
    }

    public boolean setAttributeToken(LdapFilterToken attributeToken) {
        if (this.attributeToken == null && attributeToken != null && attributeToken.getType() == 61) {
            if (super.getStartToken() == null) {
                super.setStartToken(attributeToken);
            }
            this.attributeToken = attributeToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getAttributeToken() {
        return this.attributeToken;
    }

    public boolean setDnAttrColonToken(LdapFilterToken dnAttrColonToken) {
        if (this.dnAttrColonToken == null && dnAttrColonToken != null && dnAttrColonToken.getType() == 62) {
            if (super.getStartToken() == null) {
                super.setStartToken(dnAttrColonToken);
            }
            this.dnAttrColonToken = dnAttrColonToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getDnAttrColonToken() {
        return this.dnAttrColonToken;
    }

    public boolean setDnAttrToken(LdapFilterToken dnAttrToken) {
        if (this.dnAttrToken == null && dnAttrToken != null && dnAttrToken.getType() == 63) {
            this.dnAttrToken = dnAttrToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getDnAttrToken() {
        return this.dnAttrToken;
    }

    public boolean setMatchingRuleColonToken(LdapFilterToken matchingRuleColonToken) {
        if (this.matchingRuleColonToken == null && matchingRuleColonToken != null && matchingRuleColonToken.getType() == 64) {
            if (super.getStartToken() == null) {
                super.setStartToken(matchingRuleColonToken);
            }
            this.matchingRuleColonToken = matchingRuleColonToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getMatchingRuleColonToken() {
        return this.matchingRuleColonToken;
    }

    public boolean setMatchingRuleToken(LdapFilterToken matchingRuleToken) {
        if (this.matchingRuleToken == null && matchingRuleToken != null && matchingRuleToken.getType() == 65) {
            this.matchingRuleToken = matchingRuleToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getMatchingRuleToken() {
        return this.matchingRuleToken;
    }

    public boolean setEqualsColonToken(LdapFilterToken equalsColonToken) {
        if (this.equalsColonToken == null && equalsColonToken != null && equalsColonToken.getType() == 66) {
            this.equalsColonToken = equalsColonToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getEqualsColonToken() {
        return this.equalsColonToken;
    }

    public boolean setEqualsToken(LdapFilterToken equalsToken) {
        if (this.equalsToken == null && equalsToken != null && equalsToken.getType() == 41) {
            this.equalsToken = equalsToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getEqualsToken() {
        return this.equalsToken;
    }

    public boolean setValueToken(LdapFilterToken valueToken) {
        if (this.valueToken == null && valueToken != null && valueToken.getType() == 51) {
            this.valueToken = valueToken;
            return true;
        }
        return false;
    }

    public LdapFilterToken getValueToken() {
        return this.valueToken;
    }

    @Override
    public boolean isValid() {
        return this.startToken != null && this.equalsColonToken != null & this.equalsToken != null && this.valueToken != null && (this.attributeToken != null && (this.dnAttrColonToken == null && this.dnAttrToken == null || this.dnAttrColonToken != null && this.dnAttrToken != null) && (this.matchingRuleColonToken == null && this.matchingRuleToken == null || this.matchingRuleColonToken != null && this.matchingRuleToken != null) || this.attributeToken == null && (this.dnAttrColonToken == null && this.dnAttrToken == null || this.dnAttrColonToken != null && this.dnAttrToken != null) && this.matchingRuleColonToken != null && this.matchingRuleToken != null);
    }

    @Override
    public LdapFilterToken[] getTokens() {
        ArrayList<LdapFilterToken> tokenList = new ArrayList<LdapFilterToken>();
        if (this.attributeToken != null) {
            tokenList.add(this.attributeToken);
        }
        if (this.dnAttrColonToken != null) {
            tokenList.add(this.dnAttrColonToken);
        }
        if (this.dnAttrToken != null) {
            tokenList.add(this.dnAttrToken);
        }
        if (this.matchingRuleColonToken != null) {
            tokenList.add(this.matchingRuleColonToken);
        }
        if (this.matchingRuleToken != null) {
            tokenList.add(this.matchingRuleToken);
        }
        if (this.equalsColonToken != null) {
            tokenList.add(this.equalsColonToken);
        }
        if (this.equalsToken != null) {
            tokenList.add(this.equalsToken);
        }
        if (this.valueToken != null) {
            tokenList.add(this.valueToken);
        }
        Object[] tokens = tokenList.toArray(new LdapFilterToken[tokenList.size()]);
        Arrays.sort(tokens);
        return tokens;
    }

    public String toString() {
        return String.valueOf(this.attributeToken != null ? this.startToken.getValue() : "") + (this.dnAttrColonToken != null ? this.dnAttrColonToken.getValue() : "") + (this.dnAttrToken != null ? this.dnAttrToken.getValue() : "") + (this.matchingRuleColonToken != null ? this.matchingRuleColonToken.getValue() : "") + (this.matchingRuleToken != null ? this.matchingRuleToken.getValue() : "") + (this.equalsColonToken != null ? this.equalsColonToken.getValue() : "") + (this.equalsToken != null ? this.equalsToken.getValue() : "") + (this.valueToken != null ? this.valueToken.getValue() : "");
    }

    @Override
    public boolean addFilter(LdapFilter filter) {
        return false;
    }

    @Override
    public LdapFilter[] getInvalidFilters() {
        if (this.isValid()) {
            return new LdapFilter[0];
        }
        return new LdapFilter[]{this.parent};
    }

    @Override
    public LdapFilter getFilter(int offset) {
        if (this.startToken != null && this.startToken.getOffset() <= offset && offset < this.startToken.getOffset() + this.toString().length()) {
            return this.parent;
        }
        return null;
    }

    @Override
    public String getInvalidCause() {
        if (this.dnAttrColonToken != null && this.dnAttrToken == null) {
            return Messages.LdapFilterExtensibleComponent_MissingDn;
        }
        if (this.matchingRuleColonToken != null && this.matchingRuleToken == null) {
            return Messages.LdapFilterExtensibleComponent_MissingMatchingRule;
        }
        if (this.equalsColonToken == null) {
            return Messages.LdapFilterExtensibleComponent_MissingColon;
        }
        if (this.equalsToken == null) {
            return Messages.LdapFilterExtensibleComponent_MissingEquals;
        }
        if (this.attributeToken == null) {
            return Messages.LdapFilterExtensibleComponent_MissingAttributeType;
        }
        if (this.valueToken != null) {
            return Messages.LdapFilterExtensibleComponent_MissingValue;
        }
        return null;
    }
}

