/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter.parser;

import java.util.Stack;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapAndFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterExtensibleComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterItemComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapNotFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapOrFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterScanner;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapFilterParser {
    private LdapFilterScanner scanner = new LdapFilterScanner();
    private Stack<LdapFilter> filterStack;
    private LdapFilter model = new LdapFilter();

    public LdapFilter getModel() {
        return this.model;
    }

    public void parse(String ldapFilter) {
        this.filterStack = new Stack();
        this.scanner.reset(ldapFilter);
        this.model = new LdapFilter();
        LdapFilterToken token = this.scanner.nextToken();
        while (token.getType() != 11 && token.getType() != -1) {
            this.handleError(false, token, this.model);
            token = this.scanner.nextToken();
        }
        if (token.getType() == 11) {
            this.model.setStartToken(token);
            this.filterStack.push(this.model);
            do {
                token = this.scanner.nextToken();
                switch (token.getType()) {
                    case 11: {
                        LdapFilter newFilter = new LdapFilter();
                        newFilter.setStartToken(token);
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        if (filterComponent != null && filterComponent.addFilter(newFilter)) {
                            this.filterStack.push(newFilter);
                            break;
                        }
                        currentFilter.addOtherToken(token);
                        break;
                    }
                    case 12: {
                        LdapFilter currentFilter = this.filterStack.pop();
                        this.handleError(currentFilter.setStopToken(token), token, currentFilter);
                        break;
                    }
                    case 21: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = new LdapAndFilterComponent(currentFilter);
                        ((LdapAndFilterComponent)filterComponent).setStartToken(token);
                        this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                        break;
                    }
                    case 22: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = new LdapOrFilterComponent(currentFilter);
                        ((LdapOrFilterComponent)filterComponent).setStartToken(token);
                        this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                        break;
                    }
                    case 23: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = new LdapNotFilterComponent(currentFilter);
                        ((LdapNotFilterComponent)filterComponent).setStartToken(token);
                        this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                        break;
                    }
                    case 31: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = new LdapFilterItemComponent(currentFilter);
                        ((LdapFilterItemComponent)filterComponent).setAttributeToken(token);
                        this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                        break;
                    }
                    case 51: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        if (filterComponent instanceof LdapFilterItemComponent) {
                            this.handleError(filterComponent instanceof LdapFilterItemComponent && ((LdapFilterItemComponent)filterComponent).setValueToken(token), token, currentFilter);
                            break;
                        }
                        if (filterComponent instanceof LdapFilterExtensibleComponent) {
                            this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setValueToken(token), token, currentFilter);
                            break;
                        }
                        this.handleError(false, token, currentFilter);
                        break;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        if (filterComponent instanceof LdapFilterItemComponent) {
                            this.handleError(filterComponent instanceof LdapFilterItemComponent && ((LdapFilterItemComponent)filterComponent).setFiltertypeToken(token), token, currentFilter);
                            break;
                        }
                        if (filterComponent instanceof LdapFilterExtensibleComponent) {
                            this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setEqualsToken(token), token, currentFilter);
                            break;
                        }
                        this.handleError(false, token, currentFilter);
                        break;
                    }
                    case 1: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        currentFilter.addOtherToken(token);
                        break;
                    }
                    case 61: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = new LdapFilterExtensibleComponent(currentFilter);
                        ((LdapFilterExtensibleComponent)filterComponent).setAttributeToken(token);
                        this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                        break;
                    }
                    case 62: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        if (filterComponent == null) {
                            filterComponent = new LdapFilterExtensibleComponent(currentFilter);
                            ((LdapFilterExtensibleComponent)filterComponent).setDnAttrColonToken(token);
                            this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                            break;
                        }
                        this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setDnAttrColonToken(token), token, currentFilter);
                        break;
                    }
                    case 63: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setDnAttrToken(token), token, currentFilter);
                        break;
                    }
                    case 64: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        if (filterComponent == null) {
                            filterComponent = new LdapFilterExtensibleComponent(currentFilter);
                            ((LdapFilterExtensibleComponent)filterComponent).setMatchingRuleColonToken(token);
                            this.handleError(currentFilter.setFilterComponent(filterComponent), token, currentFilter);
                            break;
                        }
                        this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setMatchingRuleColonToken(token), token, currentFilter);
                        break;
                    }
                    case 65: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setMatchingRuleToken(token), token, currentFilter);
                        break;
                    }
                    case 66: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        LdapFilterComponent filterComponent = currentFilter.getFilterComponent();
                        this.handleError(filterComponent instanceof LdapFilterExtensibleComponent && ((LdapFilterExtensibleComponent)filterComponent).setEqualsColonToken(token), token, currentFilter);
                        break;
                    }
                    case -1: {
                        this.model.addOtherToken(token);
                        break;
                    }
                    default: {
                        LdapFilter currentFilter = this.filterStack.peek();
                        this.handleError(false, token, currentFilter);
                    }
                }
            } while (!this.filterStack.isEmpty() && token.getType() != -1);
        }
        token = this.scanner.nextToken();
        while (token.getType() != -1) {
            this.handleError(false, token, this.model);
            token = this.scanner.nextToken();
        }
    }

    private void handleError(boolean success, LdapFilterToken token, LdapFilter filter) {
        if (!success) {
            filter.addOtherToken(new LdapFilterToken(-2, token.getValue(), token.getOffset()));
        }
    }
}

