/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.schema;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.parser.LdifParser;

public class Schema {
    public static final String SCHEMA_FILTER = "(objectClass=subschema)";
    public static final String RAW_SCHEMA_DEFINITION_LDIF_VALUE = "X-RAW-SCHEMA-DEFINITION";
    public static final String DN_SYNTAX_OID = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final LdapSyntax DUMMY_LDAP_SYNTAX = new LdapSyntax("", "");
    public static final HashMap<String, List<String>> DUMMY_EXTENSIONS = new HashMap();
    public static final Schema DEFAULT_SCHEMA;
    private boolean defaultSchema = false;
    private LdifContentRecord schemaRecord = null;
    private Dn dn = null;
    private String createTimestamp = null;
    private String modifyTimestamp = null;
    private Map<String, ObjectClass> ocdMapByNameOrNumericOid = new HashMap<String, ObjectClass>();
    private Map<String, AttributeType> atdMapByNameOrNumericOid = new HashMap<String, AttributeType>();
    private Map<String, LdapSyntax> lsdMapByNumericOid = new HashMap<String, LdapSyntax>();
    private Map<String, MatchingRule> mrdMapByNameOrNumericOid = new HashMap<String, MatchingRule>();
    private Map<String, MatchingRuleUse> mrudMapByNameOrNumericOid = new HashMap<String, MatchingRuleUse>();

    static {
        ArrayList<String> dummyValues = new ArrayList<String>();
        dummyValues.add("DUMMY");
        DUMMY_EXTENSIONS.put("X-DUMMY", dummyValues);
        Schema defaultSchema = null;
        try {
            URL url = Schema.class.getClassLoader().getResource("default_schema.ldif");
            InputStream is = url.openStream();
            InputStreamReader reader = new InputStreamReader(is);
            defaultSchema = new Schema();
            defaultSchema.defaultSchema = true;
            defaultSchema.loadFromLdif(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEFAULT_SCHEMA = defaultSchema;
    }

    public boolean isDefault() {
        return this.defaultSchema;
    }

    public void loadFromLdif(Reader reader) {
        try {
            LdifParser parser = new LdifParser();
            LdifEnumeration enumeration = parser.parse(reader);
            while (enumeration.hasNext()) {
                LdifContainer container = enumeration.next();
                if (!(container instanceof LdifContentRecord)) continue;
                LdifContentRecord schemaRecord = (LdifContentRecord)container;
                this.parseSchemaRecord(schemaRecord);
            }
        }
        catch (Exception e) {
            System.out.println("Schema#loadFromLdif: " + e.toString());
        }
    }

    public void loadFromRecord(LdifContentRecord schemaRecord) {
        try {
            this.parseSchemaRecord(schemaRecord);
        }
        catch (Exception e) {
            System.out.println("Schema#loadFromRecord: " + e.toString());
        }
    }

    public void saveToLdif(Writer writer) {
        try {
            writer.write(this.getSchemaRecord().toFormattedString(LdifFormatParameters.DEFAULT));
        }
        catch (Exception e) {
            System.out.println("Schema#saveToLdif: " + e.toString());
        }
    }

    private void parseSchemaRecord(LdifContentRecord schemaRecord) throws Exception {
        this.setSchemaRecord(schemaRecord);
        this.setDn(new Dn(new String[]{schemaRecord.getDnLine().getValueAsString()}));
        ObjectClassDescriptionSchemaParser ocdPparser = new ObjectClassDescriptionSchemaParser();
        ocdPparser.setQuirksMode(true);
        AttributeTypeDescriptionSchemaParser atdParser = new AttributeTypeDescriptionSchemaParser();
        atdParser.setQuirksMode(true);
        LdapSyntaxDescriptionSchemaParser lsdParser = new LdapSyntaxDescriptionSchemaParser();
        lsdParser.setQuirksMode(true);
        MatchingRuleDescriptionSchemaParser mrdParser = new MatchingRuleDescriptionSchemaParser();
        mrdParser.setQuirksMode(true);
        MatchingRuleUseDescriptionSchemaParser mrudParser = new MatchingRuleUseDescriptionSchemaParser();
        mrudParser.setQuirksMode(true);
        LdifAttrValLine[] lines = schemaRecord.getAttrVals();
        int i = 0;
        while (i < lines.length) {
            LdifAttrValLine line = lines[i];
            String attributeName = line.getUnfoldedAttributeDescription();
            String value = line.getValueAsString();
            ArrayList<String> ldifValues = new ArrayList<String>(1);
            ldifValues.add(value);
            try {
                if (attributeName.equalsIgnoreCase("objectClasses")) {
                    ObjectClass ocd = ocdPparser.parse(value);
                    ocd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addObjectClass(ocd);
                } else if (attributeName.equalsIgnoreCase("attributeTypes")) {
                    AttributeType atd = atdParser.parse(value);
                    atd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addAttributeType(atd);
                } else if (attributeName.equalsIgnoreCase("ldapSyntaxes")) {
                    LdapSyntax lsd = lsdParser.parse(value);
                    if (StringUtils.isEmpty((CharSequence)lsd.getDescription()) && Utils.getOidDescription((String)lsd.getOid()) != null) {
                        lsd.setDescription(Utils.getOidDescription((String)lsd.getOid()));
                    }
                    lsd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addLdapSyntax(lsd);
                } else if (attributeName.equalsIgnoreCase("matchingRules")) {
                    MatchingRule mrd = mrdParser.parse(value);
                    mrd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addMatchingRule(mrd);
                } else if (attributeName.equalsIgnoreCase("matchingRuleUse")) {
                    MatchingRuleUse mrud = mrudParser.parse(value);
                    mrud.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addMatchingRuleUse(mrud);
                } else if (attributeName.equalsIgnoreCase("createTimestamp")) {
                    this.setCreateTimestamp(value);
                } else if (attributeName.equalsIgnoreCase("modifyTimestamp")) {
                    this.setModifyTimestamp(value);
                }
            }
            catch (Exception e) {
                System.out.println("Error reading schema: " + attributeName + " = " + value);
                System.out.println(e.getMessage());
            }
            ++i;
        }
        for (AttributeType atd : this.getAttributeTypeDescriptions()) {
            String syntaxOid = atd.getSyntaxOid();
            if (syntaxOid != null && !this.hasLdapSyntaxDescription(syntaxOid)) {
                LdapSyntax lsd = new LdapSyntax(syntaxOid);
                lsd.setDescription(Utils.getOidDescription((String)syntaxOid));
                this.addLdapSyntax(lsd);
            }
            String emr = atd.getEqualityOid();
            String omr = atd.getOrderingOid();
            String smr = atd.getSubstringOid();
            this.checkMatchingRules(emr, omr, smr);
        }
        ObjectClass extensibleObjectOcd = this.getObjectClassDescription("extensibleObject");
        Collection<AttributeType> userAtds = SchemaUtils.getUserAttributeDescriptions(this);
        Collection<String> atdNames = SchemaUtils.getNames(userAtds);
        ArrayList<String> atdNames2 = new ArrayList<String>(atdNames);
        extensibleObjectOcd.setMayAttributeTypeOids(atdNames2);
    }

    private void checkMatchingRules(String ... matchingRules) {
        String[] stringArray = matchingRules;
        int n = matchingRules.length;
        int n2 = 0;
        while (n2 < n) {
            String matchingRule = stringArray[n2];
            if (matchingRule != null && !this.hasMatchingRuleDescription(matchingRule)) {
                MatchingRule mrd = new MatchingRule(matchingRule);
                mrd.addName(new String[]{matchingRule});
                this.addMatchingRule(mrd);
            }
            ++n2;
        }
    }

    public LdifContentRecord getSchemaRecord() {
        return this.schemaRecord;
    }

    public void setSchemaRecord(LdifContentRecord schemaRecord) {
        this.schemaRecord = schemaRecord;
    }

    public Dn getDn() {
        return this.dn;
    }

    public void setDn(Dn dn) {
        this.dn = dn;
    }

    public String getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(String createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getModifyTimestamp() {
        return this.modifyTimestamp;
    }

    public void setModifyTimestamp(String modifyTimestamp) {
        this.modifyTimestamp = modifyTimestamp;
    }

    private void addObjectClass(ObjectClass ocd) {
        if (ocd.getOid() != null) {
            this.ocdMapByNameOrNumericOid.put(Strings.toLowerCase((String)ocd.getOid()), ocd);
        }
        if (ocd.getNames() != null && !ocd.getNames().isEmpty()) {
            for (String ocdName : ocd.getNames()) {
                this.ocdMapByNameOrNumericOid.put(Strings.toLowerCase((String)ocdName), ocd);
            }
        }
    }

    public Collection<ObjectClass> getObjectClassDescriptions() {
        HashSet<ObjectClass> set = new HashSet<ObjectClass>(this.ocdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasObjectClassDescription(String nameOrOid) {
        if (nameOrOid != null) {
            return this.ocdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid));
        }
        return false;
    }

    public ObjectClass getObjectClassDescription(String nameOrOid) {
        if (this.ocdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid))) {
            return this.ocdMapByNameOrNumericOid.get(Strings.toLowerCase((String)nameOrOid));
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getObjectClassDescription(nameOrOid);
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(nameOrOid);
        ObjectClass ocd = new ObjectClass(nameOrOid);
        ocd.setNames(names);
        ocd.setExtensions(DUMMY_EXTENSIONS);
        return ocd;
    }

    private void addAttributeType(AttributeType atd) {
        if (atd.getOid() != null) {
            this.atdMapByNameOrNumericOid.put(Strings.toLowerCase((String)atd.getOid()), atd);
        }
        if (atd.getNames() != null && !atd.getNames().isEmpty()) {
            for (String atdName : atd.getNames()) {
                this.atdMapByNameOrNumericOid.put(Strings.toLowerCase((String)atdName), atd);
            }
        }
    }

    public Collection<AttributeType> getAttributeTypeDescriptions() {
        HashSet<AttributeType> set = new HashSet<AttributeType>(this.atdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasAttributeTypeDescription(String nameOrOid) {
        if (nameOrOid != null) {
            return this.atdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid));
        }
        return false;
    }

    public AttributeType getAttributeTypeDescription(String nameOrOid) {
        AttributeDescription ad = new AttributeDescription(nameOrOid);
        String attributeType = ad.getParsedAttributeType();
        if (this.atdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)attributeType))) {
            return this.atdMapByNameOrNumericOid.get(Strings.toLowerCase((String)attributeType));
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getAttributeTypeDescription(attributeType);
        }
        ArrayList<String> attributeTypes = new ArrayList<String>();
        attributeTypes.add(attributeType);
        AttributeType atd = new AttributeType(attributeType);
        atd.setNames(attributeTypes);
        atd.setUserModifiable(true);
        atd.setUsage(UsageEnum.USER_APPLICATIONS);
        atd.setExtensions(DUMMY_EXTENSIONS);
        return atd;
    }

    private void addLdapSyntax(LdapSyntax lsd) {
        if (lsd.getOid() != null) {
            this.lsdMapByNumericOid.put(Strings.toLowerCase((String)lsd.getOid()), lsd);
        }
    }

    public Collection<LdapSyntax> getLdapSyntaxDescriptions() {
        HashSet<LdapSyntax> set = new HashSet<LdapSyntax>(this.lsdMapByNumericOid.values());
        return set;
    }

    public boolean hasLdapSyntaxDescription(String numericOid) {
        if (numericOid != null) {
            return this.lsdMapByNumericOid.containsKey(Strings.toLowerCase((String)numericOid));
        }
        return false;
    }

    public LdapSyntax getLdapSyntaxDescription(String numericOid) {
        if (numericOid == null) {
            return DUMMY_LDAP_SYNTAX;
        }
        if (this.lsdMapByNumericOid.containsKey(Strings.toLowerCase((String)numericOid))) {
            return this.lsdMapByNumericOid.get(Strings.toLowerCase((String)numericOid));
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getLdapSyntaxDescription(numericOid);
        }
        LdapSyntax lsd = new LdapSyntax(numericOid);
        lsd.setExtensions(DUMMY_EXTENSIONS);
        return lsd;
    }

    private void addMatchingRule(MatchingRule mrd) {
        if (mrd.getOid() != null) {
            this.mrdMapByNameOrNumericOid.put(Strings.toLowerCase((String)mrd.getOid()), mrd);
        }
        if (mrd.getNames() != null && !mrd.getNames().isEmpty()) {
            for (String mrdName : mrd.getNames()) {
                this.mrdMapByNameOrNumericOid.put(Strings.toLowerCase((String)mrdName), mrd);
            }
        }
    }

    public Collection<MatchingRule> getMatchingRuleDescriptions() {
        HashSet<MatchingRule> set = new HashSet<MatchingRule>(this.mrdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasMatchingRuleDescription(String nameOrOid) {
        if (nameOrOid != null) {
            return this.mrdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid));
        }
        return false;
    }

    public MatchingRule getMatchingRuleDescription(String nameOrOid) {
        if (this.mrdMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid))) {
            return this.mrdMapByNameOrNumericOid.get(Strings.toLowerCase((String)nameOrOid));
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getMatchingRuleDescription(nameOrOid);
        }
        MatchingRule mrd = new MatchingRule(nameOrOid);
        mrd.setExtensions(DUMMY_EXTENSIONS);
        return mrd;
    }

    private void addMatchingRuleUse(MatchingRuleUse mrud) {
        if (mrud.getOid() != null) {
            this.mrudMapByNameOrNumericOid.put(Strings.toLowerCase((String)mrud.getOid()), mrud);
        }
        if (mrud.getNames() != null && !mrud.getNames().isEmpty()) {
            for (String mrudName : mrud.getNames()) {
                this.mrudMapByNameOrNumericOid.put(Strings.toLowerCase((String)mrudName), mrud);
            }
        }
    }

    public Collection<MatchingRuleUse> getMatchingRuleUseDescriptions() {
        HashSet<MatchingRuleUse> set = new HashSet<MatchingRuleUse>(this.mrudMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasMatchingRuleUseDescription(String nameOrOid) {
        if (nameOrOid != null) {
            return this.mrudMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid));
        }
        return false;
    }

    public MatchingRuleUse getMatchingRuleUseDescription(String nameOrOid) {
        if (this.mrudMapByNameOrNumericOid.containsKey(Strings.toLowerCase((String)nameOrOid))) {
            return this.mrudMapByNameOrNumericOid.get(Strings.toLowerCase((String)nameOrOid));
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getMatchingRuleUseDescription(nameOrOid);
        }
        MatchingRuleUse mrud = new MatchingRuleUse(nameOrOid);
        mrud.setExtensions(DUMMY_EXTENSIONS);
        return mrud;
    }
}

