/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.core.jobs;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.directory.studio.common.core.jobs.Messages;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioProgressMonitorWatcherJob
extends Job {
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final ConcurrentLinkedQueue<StudioProgressMonitor> monitors = new ConcurrentLinkedQueue();

    public StudioProgressMonitorWatcherJob() {
        super(Messages.getString("StudioProgressMonitor.CheckCancellation"));
    }

    public void stop() {
        this.running.set(false);
    }

    public void addMonitor(StudioProgressMonitor monitor) {
        this.monitors.add(monitor);
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (this.running.get()) {
            Iterator<StudioProgressMonitor> it = this.monitors.iterator();
            block3: while (it.hasNext()) {
                StudioProgressMonitor next;
                StudioProgressMonitor spm = next = it.next();
                do {
                    if (!spm.isCanceled() && !spm.isDone) {
                        spm.allowMessageReporting.set(true);
                    }
                    if (spm.isCanceled()) {
                        spm.fireCancelRequested();
                    }
                    if (!spm.isCanceled() && !spm.isDone) continue;
                    it.remove();
                    continue block3;
                } while ((spm = spm.getWrappedProgressMonitor() instanceof StudioProgressMonitor ? (StudioProgressMonitor)spm.getWrappedProgressMonitor() : null) != null);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return Status.OK_STATUS;
    }
}

