/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.ArrayList;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SearchResultEditorFilter
extends ViewerFilter {
    protected SearchResultEditorContentProvider contentProvider;
    protected String quickFilterValue = "";
    private boolean showDn;

    public void connect(SearchResultEditorContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void inputChanged(ISearch newSearch, boolean showDn) {
        this.showDn = showDn;
    }

    public boolean isFiltered() {
        return this.quickFilterValue != null && !"".equals(this.quickFilterValue);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.isFiltered()) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                Object element = elements[i];
                if (this.select(viewer, parent, element)) {
                    out.add(element);
                }
                ++i;
            }
            return out.toArray();
        }
        return elements;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ISearchResult) {
            ISearchResult searchResult = (ISearchResult)element;
            String[] returningAttributes = searchResult.getSearch().getReturningAttributes();
            int r = 0;
            while (r < returningAttributes.length) {
                String ra = returningAttributes[r];
                AttributeHierarchy ah = searchResult.getAttributeWithSubtypes(ra);
                if (ah != null) {
                    IAttribute[] attributes = ah.getAttributes();
                    int i = 0;
                    while (i < attributes.length) {
                        IValue[] values = attributes[i].getValues();
                        int k = 0;
                        while (k < values.length) {
                            if (this.goesThroughQuickFilter(values[k])) {
                                return true;
                            }
                            ++k;
                        }
                        ++i;
                    }
                }
                ++r;
            }
            return this.showDn && searchResult.getDn().getName().toUpperCase().indexOf(this.quickFilterValue.toUpperCase()) > -1;
        }
        return true;
    }

    private boolean goesThroughQuickFilter(IValue value) {
        if (value.isString() && value.getStringValue().toUpperCase().indexOf(this.quickFilterValue.toUpperCase()) == -1) {
            return false;
        }
        return !value.isBinary();
    }

    public void dispose() {
        this.contentProvider = null;
    }

    public String getQuickFilterValue() {
        return this.quickFilterValue;
    }

    public void setQuickFilterValue(String quickFilterValue) {
        if (!this.quickFilterValue.equals(quickFilterValue)) {
            this.quickFilterValue = quickFilterValue;
            if (this.contentProvider != null) {
                this.contentProvider.refresh();
            }
        }
    }
}

