/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.eclipse.jface.resource.ImageDescriptor;

public class DeleteAllAction
extends DeleteAction {
    private static final Collection<IEntry> EMPTY_ENTRIES = new HashSet<IEntry>();
    private static final ISearch[] EMPTY_SEARCHES = new ISearch[0];
    private static final IBookmark[] EMPTY_BOOKMARKS = new IBookmark[0];

    @Override
    public void run() {
        super.run();
    }

    @Override
    public String getText() {
        if (this.getSelectedEntries().length >= 1) {
            return Messages.getString("DeleteAllAction.DeleteAllChildEntries");
        }
        if (this.getSelectedSearches().length >= 1 || this.getSelectedBrowserViewCategories().length == 1 && this.getSelectedBrowserViewCategories()[0].getType() == 1) {
            return Messages.getString("DeleteAllAction.DeleteAllSearches");
        }
        if (this.getSelectedBookmarks().length >= 1 || this.getSelectedBrowserViewCategories().length == 1 && this.getSelectedBrowserViewCategories()[0].getType() == 2) {
            return Messages.getString("DeleteAllAction.DeleteAllBookmarks");
        }
        return Messages.getString("DeleteAllAction.DeleteAll");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/delete_all.gif");
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    protected Collection<IEntry> getEntries() {
        if (this.getSelectedEntries().length >= 1) {
            HashSet<IEntry> values = new HashSet<IEntry>();
            values.addAll(Arrays.asList(this.getSelectedEntries()[0].getChildren()));
            return values;
        }
        return EMPTY_ENTRIES;
    }

    @Override
    protected ISearch[] getSearches() {
        if (this.getSelectedSearches().length >= 1) {
            return this.getSelectedSearches()[0].getBrowserConnection().getSearchManager().getSearches().toArray(new ISearch[0]);
        }
        if (this.getSelectedBrowserViewCategories().length == 1 && this.getSelectedBrowserViewCategories()[0].getType() == 1) {
            return this.getSelectedBrowserViewCategories()[0].getParent().getSearchManager().getSearches().toArray(new ISearch[0]);
        }
        return EMPTY_SEARCHES;
    }

    @Override
    protected IBookmark[] getBookmarks() {
        if (this.getSelectedBookmarks().length >= 1) {
            return this.getSelectedBookmarks()[0].getBrowserConnection().getBookmarkManager().getBookmarks();
        }
        if (this.getSelectedBrowserViewCategories().length == 1 && this.getSelectedBrowserViewCategories()[0].getType() == 2) {
            return this.getSelectedBrowserViewCategories()[0].getParent().getBookmarkManager().getBookmarks();
        }
        return EMPTY_BOOKMARKS;
    }
}

