/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.preferences;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.preferences.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SearchViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = PluginConstants.PREF_PAGE_SEARCH_VIEW_ID;
    private Combo labelCombo;
    private Button limitButton;
    private Text lengthText;
    private Button secondaryLabelButtonDisplay;
    private Combo secondaryLabelCombo;
    private Button secondaryLabelLimitButton;
    private Text secondaryLabelLengthText;
    private Button schemaLabelButtonDisplay;

    public SearchViewPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("SearchViewPreferencePage.GeneralSettings"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group labelGroup = new Group(composite, 0);
        labelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        labelGroup.setText(Messages.getString("SearchViewPreferencePage.Label"));
        labelGroup.setLayout((Layout)new GridLayout());
        Composite labelGroupComposite = new Composite((Composite)labelGroup, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        labelGroupComposite.setLayout((Layout)gl);
        labelGroupComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite labelComposite = new Composite(labelGroupComposite, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        labelComposite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        labelComposite.setLayoutData((Object)gd);
        Label useLabel = new Label(labelComposite, 0);
        useLabel.setText(Messages.getString("SearchViewPreferencePage.Use"));
        this.labelCombo = new Combo(labelComposite, 2060);
        this.labelCombo.setLayoutData((Object)new GridData());
        this.labelCombo.setItems(new String[]{Messages.getString("SearchViewPreferencePage.FirstName"), Messages.getString("SearchViewPreferencePage.AllAliases"), Messages.getString("SearchViewPreferencePage.OID")});
        this.labelCombo.setEnabled(true);
        Label asLabel = new Label(labelComposite, 0);
        asLabel.setText(Messages.getString("SearchViewPreferencePage.AsLabel"));
        Composite abbreviateComposite = new Composite(labelGroupComposite, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        abbreviateComposite.setLayout((Layout)gl);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        abbreviateComposite.setLayoutData((Object)gd);
        this.limitButton = new Button(abbreviateComposite, 32);
        this.limitButton.setText(Messages.getString("SearchViewPreferencePage.LimitLength"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.limitButton.setLayoutData((Object)gd);
        this.lengthText = new Text(abbreviateComposite, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 27;
        this.lengthText.setLayoutData((Object)gridData);
        this.lengthText.setTextLimit(3);
        this.lengthText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(SearchViewPreferencePage.this.lengthText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        Label charactersLabel = new Label(abbreviateComposite, 0);
        charactersLabel.setText(Messages.getString("SearchViewPreferencePage.Characters"));
        Group secondaryLabelGroup = new Group(composite, 0);
        secondaryLabelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        secondaryLabelGroup.setText(Messages.getString("SearchViewPreferencePage.SecondaryLabel"));
        secondaryLabelGroup.setLayout((Layout)new GridLayout());
        Composite secondaryLabelGroupComposite = new Composite((Composite)secondaryLabelGroup, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        secondaryLabelGroupComposite.setLayout((Layout)gl);
        secondaryLabelGroupComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.secondaryLabelButtonDisplay = new Button(secondaryLabelGroupComposite, 32);
        this.secondaryLabelButtonDisplay.setText(Messages.getString("SearchViewPreferencePage.DisplaySecondaryLabel"));
        Composite secondaryLabelComposite = new Composite(secondaryLabelGroupComposite, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        secondaryLabelComposite.setLayout((Layout)gl);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        secondaryLabelComposite.setLayoutData((Object)gd);
        Label useLabel2 = new Label(secondaryLabelComposite, 0);
        useLabel2.setText(Messages.getString("SearchViewPreferencePage.Use"));
        this.secondaryLabelCombo = new Combo(secondaryLabelComposite, 2060);
        this.secondaryLabelCombo.setLayoutData((Object)new GridData());
        this.secondaryLabelCombo.setItems(new String[]{Messages.getString("SearchViewPreferencePage.FirstName"), Messages.getString("SearchViewPreferencePage.AllAliases"), Messages.getString("SearchViewPreferencePage.OID")});
        this.secondaryLabelCombo.setEnabled(true);
        Label asLabel2 = new Label(secondaryLabelComposite, 0);
        asLabel2.setText(Messages.getString("SearchViewPreferencePage.AsSecondaryLabel"));
        Composite abbreviateComposite2 = new Composite((Composite)secondaryLabelGroup, 0);
        gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        abbreviateComposite2.setLayout((Layout)gl);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        abbreviateComposite2.setLayoutData((Object)gd);
        this.secondaryLabelLimitButton = new Button(abbreviateComposite2, 32);
        this.secondaryLabelLimitButton.setText(Messages.getString("SearchViewPreferencePage.LimitSecondaryLabel"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.secondaryLabelLimitButton.setLayoutData((Object)gd);
        this.secondaryLabelLengthText = new Text(abbreviateComposite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 27;
        this.secondaryLabelLengthText.setLayoutData((Object)gridData);
        this.secondaryLabelLengthText.setTextLimit(3);
        this.secondaryLabelLengthText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(SearchViewPreferencePage.this.secondaryLabelLengthText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        Label secondaryLabelcharactersLabel = new Label(abbreviateComposite2, 0);
        secondaryLabelcharactersLabel.setText(Messages.getString("SearchViewPreferencePage.Characters"));
        Group schemaLabelGroup = new Group(composite, 0);
        schemaLabelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        schemaLabelGroup.setText(Messages.getString("SearchViewPreferencePage.SchemaLabel"));
        schemaLabelGroup.setLayout((Layout)new GridLayout());
        Composite schemaLabelGroupComposite = new Composite((Composite)schemaLabelGroup, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        schemaLabelGroupComposite.setLayout((Layout)gl);
        schemaLabelGroupComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.schemaLabelButtonDisplay = new Button(schemaLabelGroupComposite, 32);
        this.schemaLabelButtonDisplay.setText(Messages.getString("SearchViewPreferencePage.DisplaySchemaLabel"));
        this.initFieldsFromPreferences();
        this.initListeners();
        this.applyDialogFont(parent);
        return parent;
    }

    private void initFieldsFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.labelCombo.select(store.getInt(PluginConstants.PREFS_SEARCH_VIEW_LABEL));
        this.limitButton.setSelection(store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE));
        this.lengthText.setEnabled(this.limitButton.getSelection());
        this.lengthText.setText(store.getString(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH));
        this.secondaryLabelButtonDisplay.setSelection(store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY));
        this.secondaryLabelCombo.select(store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL));
        this.secondaryLabelLimitButton.setSelection(store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE));
        this.secondaryLabelLengthText.setText(store.getString(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH));
        if (store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY)) {
            this.secondaryLabelCombo.setEnabled(true);
            this.secondaryLabelLimitButton.setEnabled(true);
            this.secondaryLabelLengthText.setEnabled(this.secondaryLabelLimitButton.getSelection());
        } else {
            this.secondaryLabelCombo.setEnabled(false);
            this.secondaryLabelLimitButton.setEnabled(false);
            this.secondaryLabelLengthText.setEnabled(false);
        }
        this.schemaLabelButtonDisplay.setSelection(store.getBoolean(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY));
    }

    private void initListeners() {
        this.limitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchViewPreferencePage.this.lengthText.setEnabled(SearchViewPreferencePage.this.limitButton.getSelection());
            }
        });
        this.secondaryLabelButtonDisplay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchViewPreferencePage.this.secondaryLabelButtonDisplay.getSelection()) {
                    SearchViewPreferencePage.this.secondaryLabelCombo.setEnabled(true);
                    SearchViewPreferencePage.this.secondaryLabelLimitButton.setEnabled(true);
                    SearchViewPreferencePage.this.secondaryLabelLengthText.setEnabled(SearchViewPreferencePage.this.secondaryLabelLimitButton.getSelection());
                } else {
                    SearchViewPreferencePage.this.secondaryLabelCombo.setEnabled(false);
                    SearchViewPreferencePage.this.secondaryLabelLimitButton.setEnabled(false);
                    SearchViewPreferencePage.this.secondaryLabelLengthText.setEnabled(false);
                }
            }
        });
        this.secondaryLabelLimitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchViewPreferencePage.this.secondaryLabelLengthText.setEnabled(SearchViewPreferencePage.this.secondaryLabelLimitButton.getSelection());
            }
        });
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.labelCombo.select(store.getDefaultInt(PluginConstants.PREFS_SEARCH_VIEW_LABEL));
        this.limitButton.setSelection(store.getDefaultBoolean(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE));
        this.lengthText.setEnabled(this.limitButton.getSelection());
        this.lengthText.setText(store.getDefaultString(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH));
        this.secondaryLabelButtonDisplay.setSelection(store.getDefaultBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY));
        this.secondaryLabelCombo.select(store.getDefaultInt(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL));
        this.secondaryLabelLimitButton.setSelection(store.getDefaultBoolean(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE));
        this.secondaryLabelLengthText.setText(store.getDefaultString(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH));
        if (this.secondaryLabelButtonDisplay.getSelection()) {
            this.secondaryLabelCombo.setEnabled(true);
            this.secondaryLabelLimitButton.setEnabled(true);
            this.secondaryLabelLengthText.setEnabled(this.secondaryLabelLimitButton.getSelection());
        } else {
            this.secondaryLabelCombo.setEnabled(false);
            this.secondaryLabelLimitButton.setEnabled(false);
            this.secondaryLabelLengthText.setEnabled(false);
        }
        this.schemaLabelButtonDisplay.setSelection(store.getDefaultBoolean(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (this.labelCombo.getItem(this.labelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.FirstName"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_LABEL, 0);
        } else if (this.labelCombo.getItem(this.labelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.AllAliases"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_LABEL, 1);
        } else if (this.labelCombo.getItem(this.labelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.OID"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_LABEL, 2);
        }
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE, this.limitButton.getSelection());
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH, this.lengthText.getText());
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY, this.secondaryLabelButtonDisplay.getSelection());
        if (this.secondaryLabelCombo.getItem(this.secondaryLabelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.FirstName"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL, 0);
        } else if (this.secondaryLabelCombo.getItem(this.secondaryLabelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.AllAliases"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL, 1);
        } else if (this.secondaryLabelCombo.getItem(this.secondaryLabelCombo.getSelectionIndex()).equals(Messages.getString("SearchViewPreferencePage.OID"))) {
            store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL, 2);
        }
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE, this.secondaryLabelLimitButton.getSelection());
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH, this.secondaryLabelLengthText.getText());
        store.setValue(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY, this.schemaLabelButtonDisplay.getSelection());
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

