/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class NewAttributeTypeContentWizardPage
extends AbstractWizardPage {
    private SchemaHandler schemaHandler;
    private Text superiorText;
    private Button superiorButton;
    private ComboViewer usageComboViewer;
    private ComboViewer syntaxComboViewer;
    private Spinner lengthSpinner;
    private Button obsoleteCheckbox;
    private Button singleValueCheckbox;
    private Button collectiveCheckbox;
    private Button noUserModificationCheckbox;

    protected NewAttributeTypeContentWizardPage() {
        super("NewAttributeTypeContentWizardPage");
        this.setTitle(Messages.getString("NewAttributeTypeContentWizardPage.AttributTypeContent"));
        this.setDescription(Messages.getString("NewAttributeTypeContentWizardPage.EnterAttributeTypeContent"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/attribute_type_new_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group superiorUsageGroup = new Group(composite, 0);
        superiorUsageGroup.setText(Messages.getString("NewAttributeTypeContentWizardPage.SuperiorAndUsage"));
        superiorUsageGroup.setLayout((Layout)new GridLayout(3, false));
        superiorUsageGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label superiorLabel = new Label((Composite)superiorUsageGroup, 0);
        superiorLabel.setText(Messages.getString("NewAttributeTypeContentWizardPage.Superior"));
        this.superiorText = new Text((Composite)superiorUsageGroup, 2048);
        this.superiorText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.superiorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewAttributeTypeContentWizardPage.this.verifySuperior();
            }
        });
        this.superiorButton = new Button((Composite)superiorUsageGroup, 8);
        this.superiorButton.setText(Messages.getString("NewAttributeTypeContentWizardPage.Choose"));
        this.superiorButton.setLayoutData((Object)new GridData(0, 0, false, false));
        this.superiorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
                if (dialog.open() == 0) {
                    AttributeType selectedAT = dialog.getSelectedAttributeType();
                    List aliases = selectedAT.getNames();
                    if (aliases != null && aliases.size() > 0) {
                        NewAttributeTypeContentWizardPage.this.superiorText.setText((String)aliases.get(0));
                    } else {
                        NewAttributeTypeContentWizardPage.this.superiorText.setText(selectedAT.getOid());
                    }
                }
            }
        });
        Label usageLabel = new Label((Composite)superiorUsageGroup, 0);
        usageLabel.setText(Messages.getString("NewAttributeTypeContentWizardPage.Usage"));
        Combo usageCombo = new Combo((Composite)superiorUsageGroup, 8);
        usageCombo.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.usageComboViewer = new ComboViewer(usageCombo);
        this.usageComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.usageComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.usageComboViewer.setInput((Object)new String[]{Messages.getString("NewAttributeTypeContentWizardPage.DirectoryOperation"), Messages.getString("NewAttributeTypeContentWizardPage.DistributedOperation"), Messages.getString("NewAttributeTypeContentWizardPage.DSAOperation"), Messages.getString("NewAttributeTypeContentWizardPage.UserApplications")});
        this.usageComboViewer.setSelection((ISelection)new StructuredSelection((Object)Messages.getString("NewAttributeTypeContentWizardPage.UserApplications")));
        Group syntaxGroup = new Group(composite, 0);
        syntaxGroup.setText(Messages.getString("NewAttributeTypeContentWizardPage.Syntax"));
        syntaxGroup.setLayout((Layout)new GridLayout(2, false));
        syntaxGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label syntaxLabel = new Label((Composite)syntaxGroup, 0);
        syntaxLabel.setText(Messages.getString("NewAttributeTypeContentWizardPage.SyntaxColon"));
        Combo syntaxCombo = new Combo((Composite)syntaxGroup, 8);
        syntaxCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.syntaxComboViewer = new ComboViewer(syntaxCombo);
        this.syntaxComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.syntaxComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LdapSyntax) {
                    LdapSyntax syntax = (LdapSyntax)element;
                    String description = syntax.getDescription();
                    String name = syntax.getName();
                    if (description != null || name != null) {
                        if (description != null) {
                            return NLS.bind((String)Messages.getString("NewAttributeTypeContentWizardPage.NameOID"), (Object[])new String[]{description, syntax.getOid()});
                        }
                        return NLS.bind((String)Messages.getString("NewAttributeTypeContentWizardPage.NameOID"), (Object[])new String[]{name, syntax.getOid()});
                    }
                    return NLS.bind((String)Messages.getString("NewAttributeTypeContentWizardPage.NoneOID"), (Object[])new String[]{syntax.getOid()});
                }
                return super.getText(element);
            }
        });
        Label lengthLabel = new Label((Composite)syntaxGroup, 0);
        lengthLabel.setText(Messages.getString("NewAttributeTypeContentWizardPage.Length"));
        this.lengthSpinner = new Spinner((Composite)syntaxGroup, 2048);
        this.lengthSpinner.setIncrement(1);
        this.lengthSpinner.setMinimum(0);
        this.lengthSpinner.setMaximum(Integer.MAX_VALUE);
        GridData lengthSpinnerGridData = new GridData(0, 0, false, false);
        lengthSpinnerGridData.widthHint = 42;
        this.lengthSpinner.setLayoutData((Object)lengthSpinnerGridData);
        Group propertiesGroup = new Group(composite, 0);
        propertiesGroup.setText(Messages.getString("NewAttributeTypeContentWizardPage.Properties"));
        propertiesGroup.setLayout((Layout)new GridLayout());
        propertiesGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        new Label(composite, 0);
        this.obsoleteCheckbox = new Button((Composite)propertiesGroup, 32);
        this.obsoleteCheckbox.setText(Messages.getString("NewAttributeTypeContentWizardPage.Obsolete"));
        new Label(composite, 0);
        this.singleValueCheckbox = new Button((Composite)propertiesGroup, 32);
        this.singleValueCheckbox.setText(Messages.getString("NewAttributeTypeContentWizardPage.SingleValue"));
        new Label(composite, 0);
        this.collectiveCheckbox = new Button((Composite)propertiesGroup, 32);
        this.collectiveCheckbox.setText(Messages.getString("NewAttributeTypeContentWizardPage.Collective"));
        new Label(composite, 0);
        this.noUserModificationCheckbox = new Button((Composite)propertiesGroup, 32);
        this.noUserModificationCheckbox.setText(Messages.getString("NewAttributeTypeContentWizardPage.NoUserModifcation"));
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.schemaHandler != null) {
            ArrayList<LdapSyntax> syntaxes = new ArrayList<LdapSyntax>(this.schemaHandler.getSyntaxes());
            String none = Messages.getString("NewAttributeTypeContentWizardPage.None");
            syntaxes.add((LdapSyntax)none);
            Collections.sort(syntaxes, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof LdapSyntax && o2 instanceof LdapSyntax) {
                        String o1description = ((LdapSyntax)o1).getDescription();
                        String o2description = ((LdapSyntax)o2).getDescription();
                        String o1Name = ((LdapSyntax)o1).getName();
                        String o2Name = ((LdapSyntax)o2).getName();
                        if (o1description != null && o2description != null) {
                            return o1description.compareToIgnoreCase(o2description);
                        }
                        if (o1Name != null && o2Name != null) {
                            return o1Name.compareToIgnoreCase(o2Name);
                        }
                    } else {
                        if (o1 instanceof String && o2 instanceof LdapSyntax) {
                            return Integer.MIN_VALUE;
                        }
                        if (o1 instanceof LdapSyntax && o2 instanceof String) {
                            return Integer.MAX_VALUE;
                        }
                    }
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            this.syntaxComboViewer.setInput(syntaxes);
            this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)none));
        }
    }

    private void verifySuperior() {
        String superior = this.superiorText.getText();
        if (superior != null && !superior.equals("") && this.schemaHandler.getAttributeType(this.superiorText.getText()) == null) {
            this.displayErrorMessage(Messages.getString("NewAttributeTypeContentWizardPage.ErrorSuperiorAttributeTypeNotExists"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public String getSuperiorValue() {
        String superior = this.superiorText.getText();
        if (superior != null && !superior.equals("")) {
            return superior;
        }
        return null;
    }

    public UsageEnum getUsageValue() {
        StructuredSelection selection = (StructuredSelection)this.usageComboViewer.getSelection();
        if (!selection.isEmpty()) {
            String selectedUsage = (String)selection.getFirstElement();
            if (selectedUsage.equals(Messages.getString("NewAttributeTypeContentWizardPage.DirectoryOperation"))) {
                return UsageEnum.DIRECTORY_OPERATION;
            }
            if (selectedUsage.equals(Messages.getString("NewAttributeTypeContentWizardPage.DistributedOperation"))) {
                return UsageEnum.DISTRIBUTED_OPERATION;
            }
            if (selectedUsage.equals(Messages.getString("NewAttributeTypeContentWizardPage.DSAOperation"))) {
                return UsageEnum.DSA_OPERATION;
            }
            if (selectedUsage.equals(Messages.getString("NewAttributeTypeContentWizardPage.UserApplications"))) {
                return UsageEnum.USER_APPLICATIONS;
            }
            return UsageEnum.USER_APPLICATIONS;
        }
        return UsageEnum.USER_APPLICATIONS;
    }

    public String getSyntax() {
        Object selection = ((StructuredSelection)this.syntaxComboViewer.getSelection()).getFirstElement();
        if (selection instanceof LdapSyntax) {
            return ((LdapSyntax)selection).getOid();
        }
        return null;
    }

    public int getSyntaxLengthValue() {
        return this.lengthSpinner.getSelection();
    }

    public boolean getObsoleteValue() {
        return this.obsoleteCheckbox.getSelection();
    }

    public boolean getSingleValueValue() {
        return this.singleValueCheckbox.getSelection();
    }

    public boolean getCollectiveValue() {
        return this.collectiveCheckbox.getSelection();
    }

    public boolean getNoUserModificationValue() {
        return this.noUserModificationCheckbox.getSelection();
    }
}

