/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Controls;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.EntryExistsCopyStrategyDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyEntriesRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IEntry parent;
    private IEntry[] entriesToCopy;
    private SearchScope scope;
    private EntryExistsCopyStrategyDialog dialog;

    public CopyEntriesRunnable(IEntry parent, IEntry[] entriesToCopy, SearchScope scope, EntryExistsCopyStrategyDialog dialog) {
        this.parent = parent;
        this.entriesToCopy = entriesToCopy;
        this.scope = scope;
        this.dialog = dialog;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.parent.getBrowserConnection().getConnection()};
    }

    public String getName() {
        return this.entriesToCopy.length == 1 ? BrowserCoreMessages.jobs__copy_entries_name_1 : BrowserCoreMessages.jobs__copy_entries_name_n;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.add(this.parent);
        l.addAll(Arrays.asList(this.entriesToCopy));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.entriesToCopy.length == 1 ? BrowserCoreMessages.jobs__copy_entries_error_1 : BrowserCoreMessages.jobs__copy_entries_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(this.entriesToCopy.length == 1 ? BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__copy_entries_task_1, (Object[])new String[]{this.entriesToCopy[0].getDn().getName(), this.parent.getDn().getName()}) : BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__copy_entries_task_n, (Object[])new String[]{Integer.toString(this.entriesToCopy.length), this.parent.getDn().getName()}), 2 + this.entriesToCopy.length);
        monitor.reportProgress(" ");
        monitor.worked(1);
        if (this.scope == SearchScope.OBJECT || this.scope == SearchScope.ONELEVEL || this.scope == SearchScope.SUBTREE) {
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            int copyScope = this.scope == SearchScope.SUBTREE ? 2 : (this.scope == SearchScope.ONELEVEL ? 1 : 0);
            int num = 0;
            int i = 0;
            while (!monitor.isCanceled() && i < this.entriesToCopy.length) {
                IEntry entryToCopy = this.entriesToCopy[i];
                if (this.scope == SearchScope.OBJECT || !this.parent.getDn().getNormName().endsWith(entryToCopy.getDn().getNormName())) {
                    dummyMonitor.reset();
                    num = CopyEntriesRunnable.copyEntry(entryToCopy, this.parent, null, copyScope, num, this.dialog, dummyMonitor, monitor);
                } else {
                    monitor.reportError(BrowserCoreMessages.jobs__copy_entries_source_and_target_are_equal);
                }
                ++i;
            }
            this.parent.setChildrenInitialized(false);
            this.parent.setHasChildrenHint(true);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.parent.getBrowserConnection()), this);
    }

    static int copyEntry(IEntry entryToCopy, IEntry parent, Rdn newRdn, int scope, int numberOfCopiedEntries, EntryExistsCopyStrategyDialog dialog, StudioProgressMonitor dummyMonitor, StudioProgressMonitor monitor) {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setReturningAttributes(new String[]{"*"});
        searchControls.setSearchScope(0);
        Control[] controls = null;
        if (entryToCopy.isReferral()) {
            controls = new Control[]{Controls.MANAGEDSAIT_CONTROL};
            searchControls.setReturningAttributes(new String[]{"*", "ref"});
        }
        if (entryToCopy.isSubentry()) {
            searchControls.setReturningAttributes(new String[]{"*", "subtreeSpecification"});
        }
        StudioSearchResultEnumeration result = entryToCopy.getBrowserConnection().getConnection().getConnectionWrapper().search(entryToCopy.getDn().getName(), "(objectClass=*)", searchControls, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, controls, monitor, null);
        Dn parentDn = parent.getDn();
        if (parentDn.isEmpty()) {
            parentDn = entryToCopy.getDn().getParent();
        }
        numberOfCopiedEntries = CopyEntriesRunnable.copyEntryRecursive(entryToCopy.getBrowserConnection(), result, parent.getBrowserConnection(), parentDn, newRdn, scope, numberOfCopiedEntries, dialog, dummyMonitor, monitor);
        return numberOfCopiedEntries;
    }

    static int copyEntryRecursive(IBrowserConnection sourceBrowserConnection, StudioSearchResultEnumeration entries, IBrowserConnection targetBrowserConnection, Dn parentDn, Rdn forceNewRdn, int scope, int numberOfCopiedEntries, EntryExistsCopyStrategyDialog dialog, StudioProgressMonitor dummyMonitor, StudioProgressMonitor monitor) {
        try {
            while (!monitor.isCanceled() && entries.hasMore()) {
                Entry entry = entries.next().getEntry();
                Dn oldLdapDn = entry.getDn();
                Rdn oldRdn = oldLdapDn.getRdn();
                Rdn newRdn = oldLdapDn.getRdn();
                if (forceNewRdn != null) {
                    newRdn = forceNewRdn;
                }
                Dn newLdapDn = parentDn.add(newRdn);
                entry.setDn(newLdapDn);
                CopyEntriesRunnable.applyNewRdn(entry, oldRdn, newRdn);
                Control[] controls = null;
                if (entry.hasObjectClass(new String[]{"referral"})) {
                    controls = new Control[]{Controls.MANAGEDSAIT_CONTROL};
                }
                targetBrowserConnection.getConnection().getConnectionWrapper().createEntry(entry, controls, dummyMonitor, null);
                block9: while (dummyMonitor.errorsReported()) {
                    if (dialog != null && StudioLdapException.isEntryAlreadyExistsException((Exception)dummyMonitor.getException())) {
                        dialog.setExistingEntry(targetBrowserConnection, newLdapDn);
                        dialog.open();
                        EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy strategy = dialog.getStrategy();
                        if (strategy != null) {
                            dummyMonitor.reset();
                            switch (strategy) {
                                case BREAK: {
                                    monitor.setCanceled(true);
                                    break;
                                }
                                case IGNORE_AND_CONTINUE: {
                                    break;
                                }
                                case OVERWRITE_AND_CONTINUE: {
                                    Collection<Modification> modifications = ModelConverter.toReplaceModifications(entry);
                                    targetBrowserConnection.getConnection().getConnectionWrapper().modifyEntry(newLdapDn, modifications, null, dummyMonitor, null);
                                    IEntry newEntry = targetBrowserConnection.getEntryFromCache(newLdapDn);
                                    if (newEntry == null) continue block9;
                                    newEntry.setAttributesInitialized(false);
                                    break;
                                }
                                case RENAME_AND_CONTINUE: {
                                    Rdn renamedRdn = dialog.getRdn();
                                    CopyEntriesRunnable.applyNewRdn(entry, newRdn, renamedRdn);
                                    newLdapDn = parentDn.add(renamedRdn);
                                    entry.setDn(newLdapDn);
                                    targetBrowserConnection.getConnection().getConnectionWrapper().createEntry(entry, null, dummyMonitor, null);
                                }
                            }
                            continue;
                        }
                        monitor.reportError(dummyMonitor.getException());
                        break;
                    }
                    monitor.reportError(dummyMonitor.getException());
                    break;
                }
                if (monitor.isCanceled() || monitor.errorsReported()) continue;
                monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__copied_n_entries, (Object[])new String[]{Integer.toString(++numberOfCopiedEntries)}));
                if (scope != 1 && scope != 2) continue;
                SearchControls searchControls = new SearchControls();
                searchControls.setCountLimit(0L);
                searchControls.setReturningAttributes(new String[]{"*", "ref"});
                searchControls.setSearchScope(1);
                StudioSearchResultEnumeration childEntries = sourceBrowserConnection.getConnection().getConnectionWrapper().search(oldLdapDn.getName(), "(objectClass=*)", searchControls, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, null, monitor, null);
                if (scope == 1) {
                    scope = 0;
                }
                numberOfCopiedEntries = CopyEntriesRunnable.copyEntryRecursive(sourceBrowserConnection, childEntries, targetBrowserConnection, newLdapDn, null, scope, numberOfCopiedEntries, dialog, dummyMonitor, monitor);
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        return numberOfCopiedEntries;
    }

    private static void applyNewRdn(Entry entry, Rdn oldRdn, Rdn newRdn) throws LdapException {
        for (Ava atav : oldRdn) {
            entry.remove(atav.getType(), new Value[]{atav.getValue()});
        }
        for (Ava atav : newRdn) {
            entry.add(atav.getType(), new Value[]{atav.getValue()});
        }
    }
}

