/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;

public class LdifModSpec
extends LdifContainer {
    public LdifModSpec(LdifModSpecTypeLine modSpecTypeLine) {
        super(modSpecTypeLine);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(attrVal);
    }

    public void finish(LdifModSpecSepLine modSpecSepLine) {
        if (modSpecSepLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(modSpecSepLine);
    }

    public LdifModSpecTypeLine getModSpecType() {
        return (LdifModSpecTypeLine)this.ldifParts.get(0);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList<LdifAttrValLine> ldifAttrValLines = new ArrayList<LdifAttrValLine>();
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifAttrValLine)) continue;
            ldifAttrValLines.add((LdifAttrValLine)ldifPart);
        }
        return ldifAttrValLines.toArray(new LdifAttrValLine[ldifAttrValLines.size()]);
    }

    public LdifModSpecSepLine getModSpecSep() {
        LdifPart lastPart = this.getLastPart();
        if (lastPart instanceof LdifModSpecSepLine) {
            return (LdifModSpecSepLine)lastPart;
        }
        return null;
    }

    public boolean isAdd() {
        return this.getModSpecType().isAdd();
    }

    public boolean isReplace() {
        return this.getModSpecType().isReplace();
    }

    public boolean isDelete() {
        return this.getModSpecType().isDelete();
    }

    public static LdifModSpec createAdd(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createAdd(attributeName));
    }

    public static LdifModSpec createReplace(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createReplace(attributeName));
    }

    public static LdifModSpec createDelete(String attributeName) {
        return new LdifModSpec(LdifModSpecTypeLine.createDelete(attributeName));
    }

    @Override
    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        if (this.getModSpecType() == null) {
            return false;
        }
        String att = this.getModSpecType().getUnfoldedAttributeDescription();
        int sizeAttrVals = 0;
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifAttrValLine)) continue;
            if (!att.equalsIgnoreCase(((LdifAttrValLine)ldifPart).getUnfoldedAttributeDescription())) {
                return false;
            }
            ++sizeAttrVals;
        }
        if (this.isAdd()) {
            return sizeAttrVals > 0;
        }
        return this.isDelete() || this.isReplace();
    }

    @Override
    public String getInvalidString() {
        if (this.getModSpecType() == null) {
            return "Missing mod spec line ";
        }
        int sizeAttrVals = 0;
        String att = this.getModSpecType().getUnfoldedAttributeDescription();
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifAttrValLine)) continue;
            if (!att.equalsIgnoreCase(((LdifAttrValLine)ldifPart).getUnfoldedAttributeDescription())) {
                return "Attribute descriptions don't match";
            }
            ++sizeAttrVals;
        }
        if (this.isAdd() && sizeAttrVals == 0) {
            return "Modification must contain attribute value lines ";
        }
        return null;
    }
}

