/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserLabelProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class EntryEditorOutlinePage
extends ContentOutlinePage {
    private EntryEditor entryEditor;
    protected IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            EntryEditorOutlinePage.this.refresh();
        }
    };
    private Composite noOutlineComposite;
    private Composite composite;
    private Composite fakeComposite;

    public EntryEditorOutlinePage(EntryEditor entryEditor) {
        this.entryEditor = entryEditor;
        BrowserCommonActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.fakeComposite = new Composite(parent, 0);
        this.noOutlineComposite = new Composite(this.composite, 0);
        this.noOutlineComposite.setLayout((Layout)new FillLayout());
        Label label = new Label(this.noOutlineComposite, 64);
        label.setText(Messages.getString("EntryEditorOutlinePage.NoOutline"));
        super.createControl(parent);
        final TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new EntryEditorOutlineLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new EntryEditorOutlineContentProvider());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && EntryEditorOutlinePage.this.getEntryEditorWidgetTreeViewerInput() != null) {
                    ArrayList<Object> selectionList = new ArrayList<Object>();
                    Object[] objectArray = ((IStructuredSelection)event.getSelection()).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IValue) {
                            IValue value = (IValue)element;
                            selectionList.add(value);
                        } else if (element instanceof IAttribute) {
                            IAttribute attribute = (IAttribute)element;
                            selectionList.add(attribute);
                            selectionList.addAll(Arrays.asList(attribute.getValues()));
                        } else if (element instanceof EntryWrapper) {
                            IEntry entry = ((EntryWrapper)element).entry;
                            IAttribute[] iAttributeArray = entry.getAttributes();
                            int n3 = iAttributeArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IAttribute attribute = iAttributeArray[n4];
                                selectionList.add(attribute);
                                selectionList.addAll(Arrays.asList(attribute.getValues()));
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    StructuredSelection selection = new StructuredSelection(selectionList);
                    TreeViewer entryEditorWidgetTreeViewer = EntryEditorOutlinePage.this.getEntryEditorWidgetTreeViewer();
                    if (entryEditorWidgetTreeViewer != null) {
                        entryEditorWidgetTreeViewer.setSelection((ISelection)selection);
                    }
                }
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (treeViewer.getExpandedState(obj)) {
                        treeViewer.collapseToLevel(obj, 1);
                    } else if (((ITreeContentProvider)treeViewer.getContentProvider()).hasChildren(obj)) {
                        treeViewer.expandToLevel(obj, 1);
                    }
                }
            }
        });
        this.refresh();
    }

    public void refresh(Object element) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
            TreeViewer entryEditorWidgetTreeViewer = this.getEntryEditorWidgetTreeViewer();
            if (entryEditorWidgetTreeViewer != null) {
                treeViewer.setFilters(entryEditorWidgetTreeViewer.getFilters());
            }
            treeViewer.refresh(element);
        }
    }

    public void refresh() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && this.composite != null) {
            Control treeViewerControl;
            if (this.hasAnOutline()) {
                treeViewerControl = treeViewer.getControl();
                if (treeViewerControl != null && !treeViewerControl.isDisposed()) {
                    treeViewerControl.setParent(this.composite);
                }
                this.noOutlineComposite.setParent(this.fakeComposite);
            } else {
                treeViewerControl = treeViewer.getControl();
                if (treeViewerControl != null && !treeViewerControl.isDisposed()) {
                    treeViewerControl.setParent(this.fakeComposite);
                }
                this.noOutlineComposite.setParent(this.composite);
            }
            this.composite.layout();
            if (treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
                IEntry entry;
                TreeViewer entryEditorWidgetTreeViewer = this.getEntryEditorWidgetTreeViewer();
                if (entryEditorWidgetTreeViewer != null) {
                    treeViewer.setFilters(entryEditorWidgetTreeViewer.getFilters());
                }
                if (!treeViewer.getTree().isEnabled()) {
                    treeViewer.getTree().setEnabled(true);
                }
                if ((entry = this.getEntryEditorWidgetTreeViewerInput()) == null) {
                    treeViewer.setInput(null);
                    treeViewer.getTree().setEnabled(false);
                } else {
                    treeViewer.setInput((Object)entry);
                    treeViewer.expandToLevel(2);
                }
                treeViewer.refresh();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.entryEditor != null) {
            BrowserCommonActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.entryEditor = null;
        }
    }

    private boolean hasAnOutline() {
        return this.getEntryEditorWidgetTreeViewerInput() != null;
    }

    private TreeViewer getEntryEditorWidgetTreeViewer() {
        EntryEditorWidget mainWidget;
        if (this.entryEditor != null && (mainWidget = this.entryEditor.getMainWidget()) != null) {
            TreeViewer viewer = mainWidget.getViewer();
            return viewer;
        }
        return null;
    }

    private IEntry getEntryEditorWidgetTreeViewerInput() {
        Object o;
        TreeViewer viewer = this.getEntryEditorWidgetTreeViewer();
        if (viewer != null && (o = viewer.getInput()) instanceof IEntry) {
            return (IEntry)o;
        }
        return null;
    }

    private static class EntryEditorOutlineContentProvider
    implements ITreeContentProvider {
        private EntryEditorOutlineContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IEntry) {
                IEntry entry = (IEntry)element;
                return new EntryWrapper[]{new EntryWrapper(entry)};
            }
            if (element instanceof EntryWrapper) {
                EntryWrapper entryWrapper = (EntryWrapper)element;
                return entryWrapper.entry.getAttributes();
            }
            if (element instanceof IAttribute) {
                IAttribute attribute = (IAttribute)element;
                return attribute.getValues();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class EntryEditorOutlineLabelProvider
    extends LabelProvider {
        private EntryEditorOutlineLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EntryWrapper) {
                IEntry entry = ((EntryWrapper)element).entry;
                if (entry.getDn() != null && "".equals(entry.getDn().toString())) {
                    return "Root DSE";
                }
                return entry.getDn().getName();
            }
            if (element instanceof IAttribute) {
                IAttribute attribute = (IAttribute)element;
                return String.valueOf(attribute.getDescription()) + " (" + attribute.getValueSize() + ")";
            }
            if (element instanceof IValue) {
                IValue value = (IValue)element;
                return Utils.getShortenedString((String)value.getStringValue(), (int)20);
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof EntryWrapper) {
                IEntry entry = ((EntryWrapper)element).entry;
                if (entry.getDn() != null && "".equals(entry.getDn().toString())) {
                    return BrowserCommonActivator.getDefault().getImage("resources/icons/entry_root.gif");
                }
                return BrowserLabelProvider.getImageByObjectClass((IEntry)entry);
            }
            if (element instanceof IAttribute) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_attribute.gif");
            }
            if (element instanceof IValue) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_value.gif");
            }
            return null;
        }
    }

    private static class EntryWrapper {
        IEntry entry;

        public EntryWrapper(IEntry entry) {
            this.entry = entry;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryWrapper other = (EntryWrapper)obj;
            return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
        }
    }
}

