/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import org.apache.directory.api.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.dom4j.Element;

public class ModifyDNRequestDsml
extends AbstractResultResponseRequestDsml<ModifyDnRequest, ModifyDnResponse>
implements ModifyDnRequest {
    public ModifyDNRequestDsml(LdapApiService codec) {
        super(codec, new ModifyDnRequestImpl());
    }

    public ModifyDNRequestDsml(LdapApiService codec, ModifyDnRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((ModifyDnRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ModifyDnRequest request = (ModifyDnRequest)this.getDecorated();
        if (request.getName() != null) {
            element.addAttribute("dn", request.getName().getName());
        }
        if (request.getNewRdn() != null) {
            element.addAttribute("newrdn", request.getNewRdn().getName());
        }
        element.addAttribute("deleteoldrdn", request.getDeleteOldRdn() ? "true" : "false");
        if (request.getNewRdn() != null) {
            element.addAttribute("newSuperior", request.getNewSuperior().getName());
        }
        return element;
    }

    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    public void setEntry(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
    }

    public boolean isDeleteOldRDN() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
        return this;
    }

    public MessageTypeEnum getResponseType() {
        return ((ModifyDnRequest)this.getDecorated()).getResponseType();
    }

    public ModifyDnRequest setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
        return this;
    }

    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
        return this;
    }

    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }
}

