/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.server.config.beans.ReplConsumerBean;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.ReplicationDetailsPage;
import org.apache.directory.studio.apacheds.configuration.editor.ReplicationPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ReplicationMasterDetailsBlock
extends MasterDetailsBlock {
    private static final String NEW_ID = "consumer";
    private ReplicationPage page;
    private ReplicationDetailsPage detailsPage;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;

    public ReplicationMasterDetailsBlock(ReplicationPage page) {
        this.page = page;
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
        this.sashForm.setWeights(new int[]{30, 70});
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.sashForm.setOrientation(256);
        Section section = toolkit.createSection(parent, 256);
        section.setText("All Replication Consummers");
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReplConsumerBean) {
                    ReplConsumerBean consumer = (ReplConsumerBean)element;
                    return consumer.getReplConsumerId();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof ReplConsumerBean) {
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/replication_consumer.gif");
                }
                return super.getImage(element);
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ReplConsumerBean && e2 instanceof ReplConsumerBean) {
                    ReplConsumerBean o1 = (ReplConsumerBean)e1;
                    ReplConsumerBean o2 = (ReplConsumerBean)e2;
                    String id1 = o1.getReplConsumerId();
                    String id2 = o2.getReplConsumerId();
                    if (id1 != null && id2 != null) {
                        return id1.compareTo(id2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.addButton = toolkit.createButton(client, "Add", 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, "Delete", 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    public void refreshUI() {
        this.initFromInput();
        this.viewer.refresh();
    }

    private void initFromInput() {
        this.viewer.setInput((Object)this.page.getConfigBean().getDirectoryServiceBean().getLdapServerBean().getReplConsumers());
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReplicationMasterDetailsBlock.this.viewer.refresh();
                StructuredSelection selection = (StructuredSelection)ReplicationMasterDetailsBlock.this.viewer.getSelection();
                ReplicationMasterDetailsBlock.this.deleteButton.setEnabled(!selection.isEmpty());
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationMasterDetailsBlock.this.addNewConsumer();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplicationMasterDetailsBlock.this.deleteSelectedConsumer();
            }
        });
    }

    private void addNewConsumer() {
        String newId = this.getNewId();
        ReplConsumerBean consumerBean = this.getNewReplConsumerBean();
        consumerBean.setReplConsumerId(newId);
        this.page.getConfigBean().getDirectoryServiceBean().getLdapServerBean().addReplConsumers(new ReplConsumerBean[]{consumerBean});
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)consumerBean));
        this.setEditorDirty();
    }

    private ReplConsumerBean getNewReplConsumerBean() {
        ReplConsumerBean consumerBean = new ReplConsumerBean();
        consumerBean.setEnabled(true);
        consumerBean.setReplAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES.getJndiValue());
        consumerBean.setReplProvHostName("localhost");
        consumerBean.setReplProvPort(10389);
        consumerBean.setReplSearchFilter("(objectClass=*)");
        consumerBean.setReplSearchScope(SearchScope.SUBTREE.getLdapUrlValue());
        consumerBean.setReplUserDn("uid=admin,ou=system");
        consumerBean.setReplUserPassword("secret".getBytes());
        consumerBean.setReplRefreshInterval(60000L);
        consumerBean.setReplRefreshNPersist(true);
        consumerBean.addReplAttributes(new String[]{"*"});
        consumerBean.setSearchBaseDn("dc=example,dc=com");
        return consumerBean;
    }

    private String getNewId() {
        int counter = 1;
        String name = NEW_ID;
        boolean ok = false;
        while (!ok) {
            ok = true;
            name = NEW_ID + counter;
            for (ReplConsumerBean consumer : this.page.getConfigBean().getDirectoryServiceBean().getLdapServerBean().getReplConsumers()) {
                if (!consumer.getReplConsumerId().equalsIgnoreCase(name)) continue;
                ok = false;
            }
            ++counter;
        }
        return name;
    }

    private void deleteSelectedConsumer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            ReplConsumerBean consumer = (ReplConsumerBean)selection.getFirstElement();
            if (MessageDialog.openConfirm((Shell)this.page.getManagedForm().getForm().getShell(), (String)"Confirm Delete", (String)NLS.bind((String)"Are you sure you want to delete replication consumer ''{0}''?", (Object)consumer.getReplConsumerId()))) {
                this.page.getConfigBean().getDirectoryServiceBean().getLdapServerBean().getReplConsumers().remove(consumer);
                this.setEditorDirty();
            }
        }
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new ReplicationDetailsPage(this);
        detailsPart.registerPage(ReplConsumerBean.class, (IDetailsPage)this.detailsPage);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
        this.viewer.refresh();
    }

    public void save() {
        this.detailsPage.commit(true);
    }

    public ReplicationPage getPage() {
        return this.page;
    }
}

